#!/bin/bash
#Step 0: download
#Step 1: install and write script
STEP=1

if [ $STEP -eq 0 ]; then
	# Adapted from petsc 3.2. 
	# Used Mercurial to get code
	rm -rf src
	hg clone http://petsc.cs.iit.edu/petsc/petsc-dev src
	cd src
	hg clone http://petsc.cs.iit.edu/petsc/BuildSystem config/BuildSystem
fi

# To update (via Mercurial):
#      cd petsc-dev
#      hg pull -u
#      cd config/BuildSystem
#      hg pull -u

# configure script
# Note: using metis from externalpackages did not work...
# for now downloading new metis
#   -then rename metis in externalpackages to metis2
#
#		--download-prometheus=yes \
#--download-superlu=http://crd.lbl.gov/~xiaoye/SuperLU/superlu_4.3.tar.gz \
#		--download-plapack=yes \

if [ $STEP -eq 1 ]; then

	#configure
	cd src
	./config/configure.py \
		--prefix="$ISSM_DIR/externalpackages/petsc/install" \
		--with-batch=1  \
		--PETSC_ARCH="$ISSM_ARCH" \
		--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
		--with-debugging=0 \
		--with-shared-libraries=1 \
		--with-blas-lapack-dir=/nasa/intel/mkl/10.0.011/ \
		--known-mpi-shared-libraries=1 \
		--with-mpi=1 \
		--download-mumps=yes \
		--download-scalapack=yes \
		--download-blacs=yes  \
		--download-blas=yes \
		--download-f-blas-lapack=yes \
		--download-parmetis=yes \
		--download-metis=yes \
		--download-trilinos=yes \
		--download-euclid=yes \
		--download-spai=yes \
		--download-superlu=http://crd.lbl.gov/~xiaoye/SuperLU/superlu_4.3.tar.gz \
		--download-hypre=yes \
		--with-cxx=/nasa/sgi/mpt/2.06a67/bin/mpicxx \
		--with-fc=/nasa/sgi/mpt/2.06a67/bin/mpif90 \
		--COPTFLAGS="-lmpi -O3" \
		--FOPTFLAGS="-lmpi -O3" \
		--CXXOPTFLAGS="-lmpi -O3" 
		cat > script.queue << EOF
#PBS -S /bin/bash
#PBS -l select=1:ncpus=1:model=wes 
#PBS -l walltime=200 
#PBS -W group_list=s1010 
#PBS -m e 
. /usr/share/modules/init/bash 
module load comp-intel/2012.0.032 
module load mpi-sgi/mpt.2.06a67  
module load math/intel_mkl_64_10.0.011 
export PATH="$PATH:." 
export MPI_GROUP_MAX=64 
mpiexec -np 1 ./conftest-linux-gnu-ia64-intel.py
EOF
	echo "== Now: cd src/ "
	echo "== qsub -q devel script.queue "
	echo "== Then run reconfigure script generated by PETSc and follow instructions"
fi
