#!/bin/bash
set -eu

# Set gmt version
VER="5.4.4"

# Set tarball name
TARBALL_NAME="gmt-${VER}-mac-precompiled"
TARBALL=${TARBALL_NAME}.tar.gz

# Clean up from previous installation
rm -rf install

# Download Mac precompiled gmsh from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/${TARBALL}" "${TARBALL}"

# Untar gmt
tar -xvzf $TARBALL

# Rename untarred dir
mv $TARBALL_NAME install

# Clean up
rm -f $TARBALL
