#!/bin/bash
set -eu


## Constants
#
VER="7.67.0"

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/curl-${VER}.tar.gz" "curl-${VER}.tar.gz"

# Unpack source
tar -zxvf curl-$VER.tar.gz

# Cleanup
rm -rf install src
mkdir install src

# Move source to 'src' directory
mv curl-$VER/* src
rm -rf curl-$VER

# Configure
cd src
./configure \
	--prefix="${ISSM_DIR}/externalpackages/curl/install" \
	--disable-static \
	--disable-dependency-tracking \
	--disable-manual \
	--disable-verbose

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi

# Return to initial directory
cd ../..
