import math

import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D
import numpy as np

from pairoptions import pairoptions


def meshintersect3d(x, y, z, xs, ys, zs, *args): #{{{
    '''
    MESHINTERSECT - returns indices (into x, y, and z) of common values between 
    (x, y, z) and (xs, ys, zs) (i.e. x(index) = xs; y(index) = ys).
    '''

    # Process options
    options = pairoptions(*args)

    # Retrieve tolerance
    maxtol = options.getfieldvalue('maxtol', 100000) # 100 km
    tolincrement = options.getfieldvalue('tolincrement', [])
    force = options.getfieldvalue('force', 0)

    # Go through lats, longs and find within tolerance, the index of the corresponding value in lat, long
    indices = np.zeros(len(xs))

    for i in range(len(xs)):
        tolerance = 0
        distance = math.sqrt((x - xs[i]) ** 2 + (y - ys[i]) ** 2 + (z - zs[i]) ** 2)

        s = np.where(distance == 0)[0]
        if s.size():
            if s.size() > 1:
                # We have two vertices that are coincident! Not good
                for j in range(len(s)):
                    plot(x[s[j]], y[s[j]], z[s[j]], c='cyan', s=40)
                print('Vertex %i of input mesh coincides with the following ouput mesh vertices ' % i)
                print(s)
                if force:
                    indices[i] = s[0]
                else:
                    raise RuntimeError('')
            else:
                indices[i] = s
        else:
            # We could not find a 0 distance, find the lowest tolerance that generates a find
            count = 1
            while not s.size():
                if count > 1000:
                    print('could not find a vertex matching vertex %i of input mesh!' % i)
                    print('Might think anbout changing tolerance increment')
                    raise RuntimeError('')
                tolerance = tolerance + tolincrement
                s = np.where(distance < tolerance)
                count = count + 1
            if tolerance > maxtol:
                print('found matching vertices %i in output mesh for input mesh vertex %i' % (s, i))
                print('however, these vertices are farther than the max tolerance allowed!')
                raise RuntimeError('')

            # Recover minimum distance
            sf = distance[s]
            pos = np.where(sf == sf.min())
            s = s[pos]
            indices[i] = s

    if np.where(indices == 0).size():
        raise RuntimeError('issue with transition vector having one empty slot')
#}}}
