//FOURIERLOVE class definition
//
//   Usage:
//      md.love=fourierlove();

function fourierlove (){
	//methods
	this.extrude = function(md) { // {{{
		return this;
	} // }}}
	this.setdefaultparameters = function() { // {{{
		//we setup an elastic love number computation by default.
		this.nfreq=1; 
		this.frequencies=[0]; //Hz
		this.sh_nmax=256; // .35 degree, 40 km at the equator.
		this.sh_nmin=1; 
		this.g0=10; // m/s^2; 
		this.r0=6378*1e3; //m;
		this.mu0=10**11; // Pa
		this.allow_layer_deletion=1; 
		this.love_kernels=0; 
		this.forcing_type = 11; 
	} // }}}
	this.disp = function() { // {{{
		fielddisplay(this,'nfreq','number of frequencies sampled (default 1, elastic) [Hz]');
		fielddisplay(this,'frequencies','frequencies sampled (convention defaults to 0 for the elastic case) [Hz]');
		fielddisplay(this,'sh_nmax','maximum spherical harmonic degree (default 256, .35 deg, or 40 km at equator)');
		fielddisplay(this,'sh_nmin','minimum spherical harmonic degree (default 1)');
		fielddisplay(this,'g0','adimensioning constant for gravity (default 10) [m/s^2]');
		fielddisplay(this,'r0','adimensioning constant for radius (default 6378*10^3) [m]');
		fielddisplay(this,'mu0','adimensioning constant for stress (default 10^11) [Pa]');
		fielddisplay(this,'allow_layer_deletion','allow for migration of the integration boundary with increasing spherical harmonics degree (default 1)');
		fielddisplay(this,'love_kernels','compute love numbers at depth? (default 0)');
		fielddisplay(this,'forcing_type',['integer indicating the nature and depth of the forcing for the Love number calculation (default 11) :','1:  Inner core boundary -- Volumic Potential','2:  Inner core boundary -- Pressure','3:  Inner core boundary -- Loading','4:  Inner core boundary -- Tangential traction','5:  Core mantle boundary -- Volumic Potential','6:  Core mantle boundary -- Pressure','7:  Core mantle boundary -- Loading','8:  Core mantle boundary -- Tangential traction','9:  Surface -- Volumic Potential','10: Surface -- Pressure','11: Surface -- Loading','12: Surface -- Tangential traction ']); 

	} // }}}
	this.checkconsistency = function(md,solution,analyses) { // {{{

		md = checkfield(md,'fieldname','love.nfreq','NaN',1,'Inf',1,'numel',1,'>',0);
		md = checkfield(md,'fieldname','love.frequencies','NaN',1,'Inf',1,'numel',md.love.nfreq);
		md = checkfield(md,'fieldname','love.sh_nmax','NaN',1,'Inf',1,'numel',1,'>',0);
		md = checkfield(md,'fieldname','love.sh_nmin','NaN',1,'Inf',1,'numel',1,'>',0);
		md = checkfield(md,'fieldname','love.g0','NaN',1,'Inf',1,'numel',1,'>',0);
		md = checkfield(md,'fieldname','love.r0','NaN',1,'Inf',1,'numel',1,'>',0);
		md = checkfield(md,'fieldname','love.mu0','NaN',1,'Inf',1,'numel',1,'>',0);
		md = checkfield(md,'fieldname','love.allow_layer_deletion','values',[0, 1]);
		md = checkfield(md,'fieldname','love.love_kernels','values',[0, 1]);
		md = checkfield(md,'fieldname','love.forcing_type','NaN',1,'Inf',1,'numel',1,'>',0, '<=', 12);
		if (md.love.sh_nmin<=1 && md.love.forcing_type==9) {
			throw 'Degree 1 not supported for Volumetric Potential forcing. Use sh_min>=2 for this kind of calculation.';
		}
	} // }}}
	this.marshall = function(md,prefix,fid) { // {{{
	
		WriteData(fid,prefix,'object',this,'fieldname','nfreq','format','Integer');
		WriteData(fid,prefix,'object',this,'fieldname','frequencies','format','DoubleMat','mattype',3);
		WriteData(fid,prefix,'object',this,'fieldname','sh_nmax','format','Integer');
		WriteData(fid,prefix,'object',this,'fieldname','sh_nmin','format','Integer');
		WriteData(fid,prefix,'object',this,'fieldname','g0','format','Double');
		WriteData(fid,prefix,'object',this,'fieldname','r0','format','Double');
		WriteData(fid,prefix,'object',this,'fieldname','mu0','format','Double');
		WriteData(fid,prefix,'object',this,'fieldname','allow_layer_deletion','format','Boolean');
		WriteData(fid,prefix,'object',this,'fieldname','love_kernels','format','Boolean');
		WriteData(fid,prefix,'object',this,'fieldname','forcing_type','format','Integer');

	} // }}}
	//properties 
	// {{{
		
	this.nfreq                =  NaN;
	this.frequencies          =  NaN;
	this.sh_nmax              =  NaN;
	this.sh_nmin              =  NaN;
	this.g0                   =  NaN; 
	this.r0                   =  NaN; 
	this.mu0                  =  NaN;
	this.allow_layer_deletion =  NaN;
	this.love_kernels =  NaN;
	this.forcing_type         =  NaN;
	
	//set defaults
	this.setdefaultparameters();
	// }}}
}
