/*!\file GetSolutionFromInputsx
 * \brief: update datasets using  parameter inputs
 */

#include "./GetSolutionFromInputsx.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"

void GetSolutionFromInputsx(Vector<IssmDouble>** psolution,FemModel* femmodel){

	if(VerboseModule()) _printf0_("   Get solution from inputs\n");

	/*retrieve parameters: */
	int analysisenum;
	femmodel->parameters->FindParam(&analysisenum,AnalysisTypeEnum);

	/*Get size of vector: */
	int gsize       = femmodel->nodes->NumberOfDofs(GsetEnum);
	int gsize_local = femmodel->nodes->NumberOfDofsLocal(GsetEnum);
	if(gsize==0) _error_("Allocating a Vec of size 0 as gsize=0 ");

	/*Initialize solution: */
	Vector<IssmDouble>* solution=new Vector<IssmDouble>(gsize_local,gsize);

	/*Go through elements and plug solution: */
	Analysis* analysis = EnumToAnalysis(analysisenum);
	for(int i=0;i<femmodel->elements->Size();i++){
		Element* element=xDynamicCast<Element*>(femmodel->elements->GetObjectByOffset(i));
		analysis->GetSolutionFromInputs(solution,element);
	}
	delete analysis;

	/*Assemble vector: */
	solution->Assemble();

	/*Assign output pointers:*/
	*psolution=solution;
}
