#ifndef _SEGINPUT2_H_
#define _SEGINPUT2_H_

/*Headers:*/
#include "./ElementInput2.h"
#include "../Elements/SegRef.h"

class SegInput2: public ElementInput2, public SegRef{

	public:
		/*SegInput2 constructors, destructors: {{{*/
		SegInput2();
		SegInput2(int nbe_in,int nbv_in,int interp_in);
		~SegInput2();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		Input2 *copy();
		void    DeepEcho();
		void    Echo();
		int     Id();
		void    Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction);
		int     ObjectEnum();
		/*}}}*/
		/*SegInput2 management: {{{*/
		void SetInput(int interp_in,int row,IssmDouble value_in);
		void SetInput(int interp_in,int numinds,int* rows,IssmDouble* values_in);
		void SetInput(int interp_in,int row,int numinds,IssmDouble* values_in);
		int  GetInterpolation();
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, Gauss* gauss);
		void GetInputAverage(IssmDouble* pvalue);
		IssmDouble GetInputMin();
		IssmDouble GetInputMax();
		IssmDouble GetInputMaxAbs();
		SegInput2* GetSegInput(){return this;};
		void GetInputValue(IssmDouble* pvalue,Gauss* gauss);
		void Scale(IssmDouble scalar);
		void Pow(IssmDouble scalar);
		void AXPY(Input2* xinput,IssmDouble scalar);
		void PointWiseMult(Input2* xinput);
		void Serve(int numindices,int* indices);
		void Serve(int row,int numindices);
		int  GetResultArraySize(void);
		int  GetResultInterpolation(void);
		int  GetResultNumberOfNodes(void);
		/*}}}*/
		void Reset(int interp_in);

};
#endif  /* _SEGINPUT_H */
