#ifndef _PENTAINPUT2_H_
#define _PENTAINPUT2_H_

/*Headers:*/
#include "./ElementInput2.h"
#include "../Elements/PentaRef.h"

class PentaInput2: public ElementInput2, public PentaRef{

	private:
		int isserved_collapsed;
	public:
		/*PentaInput2 constructors, destructors: {{{*/
		PentaInput2();
		PentaInput2(int nbe_in,int nbv_in,int interp_in);
		~PentaInput2();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		Input2 *copy();
		void    DeepEcho();
		void    Echo();
		int     Id();
		void    Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction);
		int     ObjectEnum();
		/*}}}*/
		/*PentaInput2 management: {{{*/
		void SetInput(int interp_in,int row,IssmDouble value_in);
		void SetInput(int interp_in,int numinds,int* rows,IssmDouble* values_in);
		void SetInput(int interp_in,int row,int numinds,IssmDouble* values_in);
		int  GetInterpolation();
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, Gauss* gauss);
		void GetInputAverage(IssmDouble* pvalue);
		IssmDouble GetInputMin();
		IssmDouble GetInputMax();
		IssmDouble GetInputMaxAbs();
		PentaInput2* GetPentaInput(){return this;};
		void GetInputValue(IssmDouble* pvalue,Gauss* gauss);
		void Scale(IssmDouble scalar);
		void Pow(IssmDouble scalar);
		void AXPY(Input2* xinput,IssmDouble scalar);
		void PointWiseMult(Input2* xinput);
		void Serve(int numindices,int* indices);
		void Serve(int row,int numindices);
		void ServeCollapsed(int row,int state);
		void SetServeCollapsed(int);
		int  GetResultArraySize(void);
		int  GetResultInterpolation(void);
		int  GetResultNumberOfNodes(void);
		/*}}}*/
		void Reset(int interp_in);

};
#endif  /* _TRIAINPUT_H */
