/*!\file BoolInput2.c
 * \brief: implementation of the BoolInput2 object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "./BoolInput2.h"
#include "../../shared/shared.h"

/*BoolInput2 constructors and destructor*/
BoolInput2::BoolInput2(){/*{{{*/
	this->size   = -1;
	this->values = NULL;
}
/*}}}*/
BoolInput2::BoolInput2(int size_in){/*{{{*/
	_assert_(size_in>0);
	_assert_(size_in<1e11);
	this->size   = size_in;
	this->values = xNew<bool>(size_in);
}
/*}}}*/
BoolInput2::~BoolInput2(){/*{{{*/
	xDelete<bool>(this->values);
}
/*}}}*/

/*Object virtual functions definitions:*/
Input2* BoolInput2::copy() {/*{{{*/

	_assert_(this->size);
	BoolInput2* output = new BoolInput2(this->size);
	xMemCpy<bool>(output->values,this->values,this->size);

	return output;

}
/*}}}*/
void BoolInput2::DeepEcho(void){/*{{{*/

	_printf_("BoolInput2 Echo:\n");
	_printf_("   Size:          "<<size<<"\n");
	printarray(this->values,this->size);
}
/*}}}*/
void BoolInput2::Echo(void){/*{{{*/
	this->DeepEcho();
}
/*}}}*/
int  BoolInput2::Id(void){ return -1; }/*{{{*/
/*}}}*/
void BoolInput2::Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction){ /*{{{*/

	MARSHALLING_ENUM(BoolInput2Enum);
	MARSHALLING(this->size);
	if(this->size > 0){
		MARSHALLING_DYNAMIC(this->values,bool,this->size)
	}
	else this->values = NULL;

}
/*}}}*/
int  BoolInput2::ObjectEnum(void){/*{{{*/

	return BoolInput2Enum;

}
/*}}}*/

/*BoolInput2 management*/
void BoolInput2::GetInput(bool* pvalue,int index){/*{{{*/

	_assert_(index>=0); 
	_assert_(index<this->size); 

	*pvalue = this->values[index];
}
/*}}}*/
void BoolInput2::SetInput(int index,bool value){/*{{{*/

	_assert_(index>=0); 
	_assert_(index<this->size); 

	this->values[index] = value;
}
/*}}}*/

/*Object functions*/
