#!/bin/bash
set -eu


# Constants
#
VER="6.2.1"

## Environnment
#
export CC=mpicc
export CXX=mpicxx
# NOTE: On macOS, SQLite3 should be installed by default, but PROJ currently
#		requires,
#
#			SQLITE3_LIBS="-lsqlite3".
#
#		On Ubuntu Linux, install the SQLite3 binary, libraries and headers
#		with,
#
#			`apt-get install sqlite3 libsqlite3-dev`
#
export SQLITE3_LIBS="-lsqlite3"

# Cleanup
rm -rf install src
mkdir install src

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "http://issm.jpl.nasa.gov/files/externalpackages/proj-${VER}.tar.gz" "proj-${VER}.tar.gz"

# Unpack source
tar -zxvf proj-$VER.tar.gz

# Move source into 'src' directory
mv proj-$VER/* src
rm -rf proj-$VER

# Configure
cd src
./configure \
	--prefix="${ISSM_DIR}/externalpackages/proj/install" \
	--disable-dependency-tracking \
	--enable-fast-install

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi
