#!/bin/bash
set -eu


# Keeping this for potential future use
#Mercurial cloning:
#hg clone -r 268 http://mercurial.mcs.anl.gov//ad/AdjoinableMPI src

# Cleanup
rm -rf install src
mkdir install src

# Download source
${ISSM_DIR}/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/adjoinablempi.tar.gz" "adjoinablempi.tar.gz"

# Unpack source
tar -zxvf adjoinablempi.tar.gz

# Configure
cd src
./configure \
	--prefix="${ISSM_DIR}/externalpackages/adjoinablempi/install" \
	--libdir="${ISSM_DIR}/externalpackages/adjoinablempi/install/lib" \
	--with-mpi-root="${ISSM_DIR}/externalpackages/mpich/install" \
	--enable-requestOnTrace

# Clean
make clean

# Compile
if [ $# -eq 0 ]; then
	make
else
	make -j $1
fi

# Install
make install
