%Test Name: FourierLoveKernels
% Homogeneous Earth, for which analytic solutions exist. 
% Love kernels for degree 2 (tested against analytic solns).  

% for volumetric potential
	md=model();
	
	md.materials=materials('litho');

	md.materials.numlayers = 10;
	md.love.forcing_type = 9;

	md.materials.density=zeros(md.materials.numlayers,1)+5511;
	md.materials.lame_mu=zeros(md.materials.numlayers,1)+0.75e11;
	md.materials.viscosity=zeros(md.materials.numlayers,1)+1e21;
	md.materials.lame_lambda=zeros(md.materials.numlayers,1)+5e17;
	md.materials.issolid=ones(md.materials.numlayers,1);
	md.materials.isburgers=zeros(md.materials.numlayers,1);
	md.materials.burgers_mu=md.materials.lame_mu/3;
	md.materials.burgers_viscosity=md.materials.viscosity/10;

	md.materials.radius =  linspace(10e3,6371e3,md.materials.numlayers+1)';
	md.love.g0 = 9.8134357285509388; % directly grabbed from fourierlovesolver for this particular case. 

	md.love.allow_layer_deletion=1;
	md.love.frequencies=0;
	md.love.nfreq=length(md.love.frequencies); % TODO: Why are we grabbing length of a scalar here?

	md.love.sh_nmin = 2;
	md.love.sh_nmax = 2;
	md.love.love_kernels=1; 

	md.miscellaneous.name='kernels';
	md.cluster=generic('name',oshostname(),'np',1);
	md.verbose=verbose('111111101');
	
	md=solve(md,'lv');

	% extract love kernels {{{ 
	y1=squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(:,1,:,1)));
	y2=squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(:,1,:,2))); 
	y3=squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(:,1,:,3))); 
	y4=squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(:,1,:,4))); 
	y5=squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(:,1,:,5))); 
	y6=squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(:,1,:,6))); 

	y1_tidal_degree2_interface1 = y1(3,1);  
	y1_tidal_degree2_interface2 = y1(3,2);  
	y1_tidal_degree2_interface7 = y1(3,7);  
	y1_tidal_degree2_interface10 = y1(3,10);  
	y1_tidal_degree2_interface11 = y1(3,11);  

	y2_tidal_degree2_interface1 = y2(3,1);  
	y2_tidal_degree2_interface2 = y2(3,2);  
	y2_tidal_degree2_interface7 = y2(3,7);  
	y2_tidal_degree2_interface10 = y2(3,10);  
	y2_tidal_degree2_interface11 = y2(3,11);  

	y3_tidal_degree2_interface1 = y3(3,1);  
	y3_tidal_degree2_interface2 = y3(3,2);  
	y3_tidal_degree2_interface7 = y3(3,7);  
	y3_tidal_degree2_interface10 = y3(3,10);  
	y3_tidal_degree2_interface11 = y3(3,11);  

	y4_tidal_degree2_interface1 = y4(3,1);  
	y4_tidal_degree2_interface2 = y4(3,2);  
	y4_tidal_degree2_interface7 = y4(3,7);  
	y4_tidal_degree2_interface10 = y4(3,10);  
	y4_tidal_degree2_interface11 = y4(3,11);  

	y5_tidal_degree2_interface1 = y5(3,1);  
	y5_tidal_degree2_interface2 = y5(3,2);  
	y5_tidal_degree2_interface7 = y5(3,7);  
	y5_tidal_degree2_interface10 = y5(3,10);  
	y5_tidal_degree2_interface11 = y5(3,11);  

	y6_tidal_degree2_interface1 = y6(3,1);  
	y6_tidal_degree2_interface2 = y6(3,2);  
	y6_tidal_degree2_interface7 = y6(3,7);  
	y6_tidal_degree2_interface10 = y6(3,10);  
	y6_tidal_degree2_interface11 = y6(3,11);  
	% }}} 

% for surface load. 

	md.love.forcing_type = 11;
	
	md=solve(md,'lv');

	% extract love kernels {{{ 
	y1=squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(:,1,:,1))); 
	y2=squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(:,1,:,2))); 
	y3=squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(:,1,:,3))); 
	y4=squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(:,1,:,4))); 
	y5=squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(:,1,:,5))); 
	y6=squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(:,1,:,6))); 

	y1_load_degree2_interface1 = y1(3,1);  
	y1_load_degree2_interface2 = y1(3,2);  
	y1_load_degree2_interface7 = y1(3,7);  
	y1_load_degree2_interface10 = y1(3,10);  
	y1_load_degree2_interface11 = y1(3,11);  

	y2_load_degree2_interface1 = y2(3,1);  
	y2_load_degree2_interface2 = y2(3,2);  
	y2_load_degree2_interface7 = y2(3,7);  
	y2_load_degree2_interface10 = y2(3,10);  
	y2_load_degree2_interface11 = y2(3,11);  

	y3_load_degree2_interface1 = y3(3,1);  
	y3_load_degree2_interface2 = y3(3,2);  
	y3_load_degree2_interface7 = y3(3,7);  
	y3_load_degree2_interface10 = y3(3,10);  
	y3_load_degree2_interface11 = y3(3,11);  

	y4_load_degree2_interface1 = y4(3,1);  
	y4_load_degree2_interface2 = y4(3,2);  
	y4_load_degree2_interface7 = y4(3,7);  
	y4_load_degree2_interface10 = y4(3,10);  
	y4_load_degree2_interface11 = y4(3,11);  

	y5_load_degree2_interface1 = y5(3,1);  
	y5_load_degree2_interface2 = y5(3,2);  
	y5_load_degree2_interface7 = y5(3,7);  
	y5_load_degree2_interface10 = y5(3,10);  
	y5_load_degree2_interface11 = y5(3,11);  

	y6_load_degree2_interface1 = y6(3,1);  
	y6_load_degree2_interface2 = y6(3,2);  
	y6_load_degree2_interface7 = y6(3,7);  
	y6_load_degree2_interface10 = y6(3,10);  
	y6_load_degree2_interface11 = y6(3,11);  
	% }}} 

field_names = {...
	'y1_tidal_degree2_interface1','y1_tidal_degree2_interface2','y1_tidal_degree2_interface7','y1_tidal_degree2_interface10','y1_tidal_degree2_interface11',... 
	'y2_tidal_degree2_interface1','y2_tidal_degree2_interface2','y2_tidal_degree2_interface7','y2_tidal_degree2_interface10','y2_tidal_degree2_interface11',... 
	'y3_tidal_degree2_interface1','y3_tidal_degree2_interface2','y3_tidal_degree2_interface7','y3_tidal_degree2_interface10','y3_tidal_degree2_interface11',... 
	'y4_tidal_degree2_interface1','y4_tidal_degree2_interface2','y4_tidal_degree2_interface7','y4_tidal_degree2_interface10','y4_tidal_degree2_interface11',... 
	'y5_tidal_degree2_interface1','y5_tidal_degree2_interface2','y5_tidal_degree2_interface7','y5_tidal_degree2_interface10','y5_tidal_degree2_interface11',... 
	'y6_tidal_degree2_interface1','y6_tidal_degree2_interface2','y6_tidal_degree2_interface7','y6_tidal_degree2_interface10','y6_tidal_degree2_interface11',... 
	'y1_load_degree2_interface1','y1_load_degree2_interface2','y1_load_degree2_interface7','y1_load_degree2_interface10','y1_load_degree2_interface11',... 
	'y2_load_degree2_interface1','y2_load_degree2_interface2','y2_load_degree2_interface7','y2_load_degree2_interface10','y2_load_degree2_interface11',... 
	'y3_load_degree2_interface1','y3_load_degree2_interface2','y3_load_degree2_interface7','y3_load_degree2_interface10','y3_load_degree2_interface11',... 
	'y4_load_degree2_interface1','y4_load_degree2_interface2','y4_load_degree2_interface7','y4_load_degree2_interface10','y4_load_degree2_interface11',... 
	'y5_load_degree2_interface1','y5_load_degree2_interface2','y5_load_degree2_interface7','y5_load_degree2_interface10','y5_load_degree2_interface11',... 
	'y6_load_degree2_interface1','y6_load_degree2_interface2','y6_load_degree2_interface7','y6_load_degree2_interface10','y6_load_degree2_interface11',... 
	};
field_tolerances={...
	9e-8, 1e-7, 3e-7, 3e-7, 3e-7,...
	9e-8, 1e-7, 3e-7, 3e-7, 1e-10,...
	9e-8, 8e-8, 2e-8, 2e-7, 4e-7,...
	9e-8, 9e-8, 2e-7, 4e-7, 1e-10,...
	4e-7, 4e-7, 2e-7, 3e-8, 2e-8,...
	2e-5, 2e-6, 2e-6, 1e-6, 2e-7,...
	3e-6, 3e-6, 3e-6, 4e-6, 4e-6,...
	3e-6, 3e-6, 2e-6, 6e-7, 1e-10,...
	3e-6, 3e-6, 5e-7, 3e-6, 5e-6,...
	3e-6, 3e-6, 9e-7, 7e-7, 1e-10,...
	4e-6, 4e-6, 3e-6, 5e-7, 3e-7,...
	3e-6, 3e-6, 2e-6, 7e-7, 2e-7...
	}; 
field_values={...
	y1_tidal_degree2_interface1, y1_tidal_degree2_interface2, y1_tidal_degree2_interface7, y1_tidal_degree2_interface10,y1_tidal_degree2_interface11,... 
	y2_tidal_degree2_interface1, y2_tidal_degree2_interface2, y2_tidal_degree2_interface7, y2_tidal_degree2_interface10,y2_tidal_degree2_interface11,... 
	y3_tidal_degree2_interface1, y3_tidal_degree2_interface2, y3_tidal_degree2_interface7, y3_tidal_degree2_interface10,y3_tidal_degree2_interface11,... 
	y4_tidal_degree2_interface1, y4_tidal_degree2_interface2, y4_tidal_degree2_interface7, y4_tidal_degree2_interface10,y4_tidal_degree2_interface11,... 
	y5_tidal_degree2_interface1, y5_tidal_degree2_interface2, y5_tidal_degree2_interface7, y5_tidal_degree2_interface10,y5_tidal_degree2_interface11,... 
	y6_tidal_degree2_interface1, y6_tidal_degree2_interface2, y6_tidal_degree2_interface7, y6_tidal_degree2_interface10,y6_tidal_degree2_interface11,... 
	y1_load_degree2_interface1, y1_load_degree2_interface2, y1_load_degree2_interface7, y1_load_degree2_interface10,y1_load_degree2_interface11,... 
	y2_load_degree2_interface1, y2_load_degree2_interface2, y2_load_degree2_interface7, y2_load_degree2_interface10,y2_load_degree2_interface11,... 
	y3_load_degree2_interface1, y3_load_degree2_interface2, y3_load_degree2_interface7, y3_load_degree2_interface10,y3_load_degree2_interface11,... 
	y4_load_degree2_interface1, y4_load_degree2_interface2, y4_load_degree2_interface7, y4_load_degree2_interface10,y4_load_degree2_interface11,... 
	y5_load_degree2_interface1, y5_load_degree2_interface2, y5_load_degree2_interface7, y5_load_degree2_interface10,y5_load_degree2_interface11,... 
	y6_load_degree2_interface1, y6_load_degree2_interface2, y6_load_degree2_interface7, y6_load_degree2_interface10,y6_load_degree2_interface11,... 
	};

