%Test Name: MomentOfIntertia

%mesh earth:
md=model;
rad_e = 6.371012*10^3; % mean radius of Earth, km
md.mesh=gmshplanet('radius',rad_e,'resolution',1000.0);  % km resolution

%parameterize slr solution:
%slr loading:  {{{
late=sum(md.mesh.lat(md.mesh.elements),2)/3;
longe=sum(md.mesh.long(md.mesh.elements),2)/3;

md.solidearth.surfaceload.icethicknesschange=zeros(md.mesh.numberofelements,1);
pos=find(late <-75 & longe >0);
md.solidearth.surfaceload.icethicknesschange(pos(6:7))=-1;

md.solidearth.sealevel=zeros(md.mesh.numberofvertices,1);
md.dsl.global_average_thermosteric_sea_level_change=[0;0];
md.dsl.sea_surface_height_change_above_geoid=zeros(md.mesh.numberofvertices+1,1);
md.dsl.sea_water_pressure_change_at_sea_floor=zeros(md.mesh.numberofvertices+1,1);

md.solidearth.settings.ocean_area_scaling = 1;

%elastic loading from love numbers:
md.solidearth.lovenumbers=lovenumbers('maxdeg',1000);

%}}}
%mask:  {{{
mask=gmtmask(md.mesh.lat,md.mesh.long);
icemask=ones(md.mesh.numberofvertices,1);
pos=find(mask==0);
icemask(pos)=-1;
pos=find(sum(mask(md.mesh.elements),2)<3);
icemask(md.mesh.elements(pos,:))=-1;
md.mask.ice_levelset=icemask;
md.mask.ocean_levelset=-icemask;

%make sure that the elements that have loads are fully grounded:
pos=find(md.solidearth.surfaceload.icethicknesschange);
md.mask.ocean_levelset(md.mesh.elements(pos,:))=1;

%make sure wherever there is an ice load, that the mask is set to ice:
md.mask.ice_levelset=ones(md.mesh.numberofvertices,1);
pos=find(md.solidearth.surfaceload.icethicknesschange);
md.mask.ice_levelset(md.mesh.elements(pos,:))=-1;
% }}}

%geometry {{{
di=md.materials.rho_ice/md.materials.rho_water;
md.geometry.thickness=ones(md.mesh.numberofvertices,1);
md.geometry.surface=(1-di)*zeros(md.mesh.numberofvertices,1);
md.geometry.base=md.geometry.surface-md.geometry.thickness;
md.geometry.bed=md.geometry.base;
% }}}
%materials {{{
md.initialization.temperature=273.25*ones(md.mesh.numberofvertices,1);
md.materials.rheology_B=paterson(md.initialization.temperature);
md.materials.rheology_n=3*ones(md.mesh.numberofelements,1);
% }}}
%Miscellaneous {{{
md.miscellaneous.name='test2010';
% }}}
%Solution parameters {{{
md.solidearth.settings.reltol=NaN;
md.solidearth.settings.abstol=1e-3;
md.solidearth.settings.computesealevelchange=1;
% }}}

%eustatic + rigid + elastic run:
md.solidearth.settings.rigid=1;
md.solidearth.settings.elastic=1; md.solidearth.settings.rotation=1;
md.cluster=generic('name',oshostname(),'np',3);

% uncomment following 2 lines for
md=solve(md,'Sealevelrise');
eus=md.results.SealevelriseSolution.SealevelRSLEustatic;
slr=md.results.SealevelriseSolution.Sealevel;
moixz=md.results.SealevelriseSolution.SealevelInertiaTensorXZ;
moiyz=md.results.SealevelriseSolution.SealevelInertiaTensorYZ;
moizz=md.results.SealevelriseSolution.SealevelInertiaTensorZZ;

% analytical moi => just checking FOR ICE only!!! {{{
% ...have to mute ** slr induced MOI in Tria.cpp ** prior to the comparison
%rad_e = rad_e*1e3; % now in meters
%areas=GetAreasSphericalTria(md.mesh.elements,md.mesh.lat,md.mesh.long,rad_e);
%lat=late*pi/180; lon=longe*pi/180;
%moi_xz = sum(-md.materials.rho_freshwater.*md.solidearth.surfaceload.icethicknesschange.*areas.*rad_e^2.*sin(lat).*cos(lat).*cos(lon));
%moi_yz = sum(-md.materials.rho_freshwater.*md.solidearth.surfaceload.icethicknesschange.*areas.*rad_e^2.*sin(lat).*cos(lat).*sin(lon));
% }}}

%Fields and tolerances to track changes
field_names     ={'eus','slr','moixz','moiyz','moizz'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={eus,slr,moixz,moiyz,moizz};

