import numpy as np

from checkfield import checkfield
from fielddisplay import fielddisplay
from WriteData import WriteData


class tidallove(object):
    '''
    TIDALLOVE class definition

        Usage:
            tidallove = tidallove()
    '''

    def __init__(self, *args): #{{{
        self.h          = 0
        self.k          = 0
        self.secular    = 0
        
        nargin = len(args)

        if nargin == 0:
            self.setdefaultparameters()
        else:
            raise Exception('constructor not supported')
    #}}}

    def __repr__(self): # {{{
        s = '   tidallove parameters:\n'
        s += '{}\n'.format(fielddisplay(self, 'h', 'tidal load Love number (deg 2)'))
        s += '{}\n'.format(fielddisplay(self, 'k', 'tidal load Love number (deg 2)'))
        s += '{}\n'.format(fielddisplay(self, 'k2secular', 'secular fluid Love number'))

        return s
    #}}}

    def setdefaultparameters(self): # {{{
        #tidal love numbers
        self.h = 0.6149 # degree 2
        self.k = 0.3055 # degree 2

        #secular fluid love number
        self.k2secular = 0.942

        return self
    #}}}

    def checkconsistency(self, md, solution, analyses): # {{{
        if not 'SealevelriseAnalysis' in analyses or solution == 'TransientSolution' and md.transient.istidallove == 0:
            return md

        md = checkfield(md, 'fieldname', 'tidallove.h', 'NaN', 1, 'Inf', 1)
        md = checkfield(md, 'fieldname', 'tidallove.k', 'NaN', 1, 'Inf', 1)
        md = checkfield(md, 'fieldname', 'tidallove.k2secular', 'NaN', 1, 'Inf', 1)

        return md
    #}}}

    def defaultoutputs(self, md): #{{{
        return []
    #}}}

    def marshall(self, prefix, md, fid): #{{{
        WriteData(fid, prefix, 'name', 'md.solidearth.love.model', 'data', 2, 'format', 'Integer')
        WriteData(fid, prefix, 'object', self, 'fieldname', 'h', 'name', 'md.solidearth.love.h', 'format', 'Double', 'mattype', 1)
        WriteData(fid, prefix, 'object', self, 'fieldname', 'k', 'name', 'md.solidearth.love.k', 'format', 'Double', 'mattype', 1)
        WriteData(fid, prefix, 'object', self, 'fieldname', 'k2secular', 'name', 'md.solidearth.love.k2secular', 'format', 'DoubleMat', 'mattype', 1)
    #}}}

    def extrude(self, md): #{{{
        return self
    #}}}

