import numpy as np

from checkfield import checkfield
from fielddisplay import fielddisplay
from WriteData import WriteData


class loadinglove(object):
    '''
    LOADINGLOVE class definition

        Usage:
            love = loadinglove()
    '''

    def __init__(self, *args): #{{{
        #regular love numbers
        self.h = 0 #provided by PREM model
        self.k = 0 #idem
        self.l = 0 #idem

        #tidal love numbers for computing rotational feedback
        self.th         = 0
        self.tk         = 0
        self.tk2secular = 0

        nargin = len(args)

        if nargin == 0:
            self.setdefaultparameters()
        else:
            raise Exception('constructor not supported')
    #}}}

    def __repr__(self): # {{{
        s = '   loadinglove parameters:\n'
        s += '{}\n'.format(fielddisplay(self, 'h', 'load Love number for radial displacement'))
        s += '{}\n'.format(fielddisplay(self, 'k', 'load Love number for gravitational potential perturbation'))
        s += '{}\n'.format(fielddisplay(self, 'l', 'load Love number for horizontal displacements'))
        s += '{}\n'.format(fielddisplay(self, 'th', 'tidal load Love number (deg 2)'))
        s += '{}\n'.format(fielddisplay(self, 'tk', 'tidal load Love number (deg 2)'))
        s += '{}\n'.format(fielddisplay(self, 'tk2secular', 'secular fluid Love number'))

        return s
    #}}}

    def setdefaultparameters(self): # {{{
        #tidal love numbers
        self.th = 0.6149 #degree 2
        self.tk = 0.3055 #degree 2

        #secular fluid love number
        self.tk2secular = 0.942

        return self
    #}}}

    def checkconsistency(self, md, solution, analyses): # {{{
        if not 'SealevelriseAnalysis' in analyses or solution == 'TransientSolution' and md.transient.islove == 0:
            return md

        md = checkfield(md, 'fieldname', 'solidearth.love.h', 'NaN', 1, 'Inf', 1)
        md = checkfield(md, 'fieldname', 'solidearth.love.k', 'NaN', 1, 'Inf', 1)
        md = checkfield(md, 'fieldname', 'solidearth.love.l', 'NaN', 1, 'Inf', 1)

        md = checkfield(md, 'fieldname', 'solidearth.love.th', 'NaN', 1, 'Inf', 1)
        md = checkfield(md, 'fieldname', 'solidearth.love.tk', 'NaN', 1, 'Inf', 1)
        md = checkfield(md, 'fieldname', 'solidearth.love.tk2secular', 'NaN', 1, 'Inf', 1)

        #check that love nunbers are provided at the same level of accuracy
        if np.shape(self.h)[0] != np.shape(self.k)[0] or np.shape(self.h)[0] != np.shape(self.kl[0]):
            raise Exception('love error message: love numbers should be provided at the same level of accuracy')

        return md
    #}}}

    def defaultoutputs(self, md): #{{{
        return []
    #}}}

    def marshall(self, prefix, md, fid): #{{{
        WriteData(fid, prefix, 'name', 'md.solidearth.love.model', 'data', 1, 'format', 'Integer')

        WriteData(fid, prefix, 'object', self, 'fieldname', 'h', 'name', 'md.solidearth.love.h', 'format', 'DoubleMat', 'mattype', 1)
        WriteData(fid, prefix, 'object', self, 'fieldname', 'k', 'name', 'md.solidearth.love.k', 'format', 'DoubleMat', 'mattype', 1)
        WriteData(fid, prefix, 'object', self, 'fieldname', 'l', 'name', 'md.solidearth.love.l', 'format', 'DoubleMat', 'mattype', 1)

        WriteData(fid, prefix, 'object', self, 'fieldname', 'th', 'name', 'md.solidearth.love.th', 'format', 'Double')
        WriteData(fid, prefix, 'object', self, 'fieldname', 'tk', 'name', 'md.solidearth.love.tk', 'format', 'Double')
        WriteData(fid, prefix, 'object', self, 'fieldname', 'tk2secular', 'name', 'md.solidearth.love.tk2secular', 'format', 'Double')
    #}}}

    def extrude(self, md): #{{{
        return self
    #}}}
