function options=checkplotoptions(md,options);
%PARSE_OPTIONS - build a structure that holds all plot options
%
%   Usage:
%      options=checkplotoptions(md,options);
%
%   See also: PLOTMODEL

%units
if exist(options,'unit'),
	if strcmpi(getfieldvalue(options,'unit'),'km')
		options=changefieldvalue(options,'unit',10^-3);
	end
end

%density
if exist(options,'density'),
	density=getfieldvalue(options,'density');
	options=changefieldvalue(options,'density',abs(ceil(density)));
end

%Show section
if exist(options,'showsection'),
	if strcmpi(getfieldvalue(options,'showsection'),'on')
		options=changefieldvalue(options,'showsection',4);
	end
end

%iceshelf values
if exist(options,'iceshelf'),
	if strcmpi(getfieldvalue(options,'iceshelf'),'none')
		options=changefieldvalue(options,'iceshelf',0);
	end
end

%icesheet values
if exist(options,'icesheet'),
	if strcmpi(getfieldvalue(options,'icesheet'),'none')
		options=changefieldvalue(options,'icesheet',0);
	end
end

%water values
if exist(options,'water'),
	if strcmpi(getfieldvalue(options,'water'),'none')
		options=changefieldvalue(options,'water',0);
	end
end

%smooth values
if exist(options,'smooth'),
	if strcmpi(getfieldvalue(options,'smooth'),'on')
		options=changefieldvalue(options,'smooth',0);
	end
end

%contouronly values
if exist(options,'contouronly'),
	if strcmpi(getfieldvalue(options,'contouronly'),'on')
		options=changefieldvalue(options,'contouronly',1);
	end
end


%Colorbar;
if exist(options,'colorbar'),
	if strcmpi(getfieldvalue(options,'colorbar'),'on')
		options=changefieldvalue(options,'colorbar',1);
	elseif strcmpi(getfieldvalue(options,'colorbar'),'off')
			options=changefieldvalue(options,'colorbar',0);
	end
end
	
%text
%1: textsize
textsizevaluesarray=cell(0,0);
if exist(options,'textsize'),
	textsizevalues=getfieldvalue(options,'textsize');
	%ischar if only one textsize -> create a cell
	if ischar(textsizevalues),
		textsizevalues={textsizevalues};
	end
else
	textsizevalues={14};
end
%2: textweight
textweightvaluesarray=cell(0,0);
if exist(options,'textweight'),
	textweightvalues=getfieldvalue(options,'textweight');
	%ischar if only one textweight -> create a cell
	if ischar(textweightvalues),
		textweightvalues={textweightvalues};
	end
else
	textweightvalues={'n'};
end
%3: textcolor
textcolorvaluesarray=cell(0,0);
if exist(options,'textcolor'),
	textcolorvalues=getfieldvalue(options,'textcolor');
	%ischar if only one textcolor -> create a cell
	if ischar(textcolorvalues),
		textcolorvalues={textcolorvalues};
	end
else
	textcolorvalues={'k'};
end
%4: textposition
textpositionvaluesarray=cell(0,0);
if exist(options,'textposition'),
	textpositionvalues=getfieldvalue(options,'textposition');
	%isnumeric if only one textposition -> create a cell
	if isnumeric(textpositionvalues),
		textpositionvalues={textpositionvalues};
	end
end
%5: textvalue
textvaluesarray=cell(0,0);
if exist(options,'text'),
	textvalues=getfieldvalue(options,'text');
	%ischar if only one expstyle -> create a cell
	if ischar(textvalues),
		textvalues={textvalues};
	end
	%get options
	for i=1:length(textvalues)
		textvaluesarray{end+1}=textvalues{i};
		%size
		if (length(textsizevalues)>=i),
			textsizevaluesarray{end+1}=textsizevalues{i};
		else
			textsizevaluesarray{end+1}=textsizevalues{1};
		end
		%weight
		if (length(textweightvalues)>=i),
			textweightvaluesarray{end+1}=textweightvalues{i};
		else
			textweightvaluesarray{end+1}=textweightvalues{1};
		end
		%color
		if (length(textcolorvalues)>=i),
			textcolorvaluesarray{end+1}=textcolorvalues{i};
		else
			textcolorvaluesarray{end+1}=textcolorvalues{1};
		end
		%position
		if (length(textpositionvalues)>=i),
			textpositionvaluesarray{end+1}=textpositionvalues{i};
		else
			error('plotmodel error message: one or more textposition is missing');
		end
	end
end
options=changefieldvalue(options,'text',textvaluesarray);
options=changefieldvalue(options,'textsize',textsizevaluesarray);
options=changefieldvalue(options,'textweight',textweightvaluesarray);
options=changefieldvalue(options,'textcolor',textcolorvaluesarray);
options=changefieldvalue(options,'textposition',textpositionvaluesarray);

%expdisp
expdispvaluesarray=cell(0,0);
expstylevaluesarray=cell(0,0);
expstylevalues=cell(0,0);
if exist(options,'expstyle'),
	expstylevalues=getfieldvalue(options,'expstyle');
	%ischar if only one expstyle -> create a cell
	if ischar(expstylevalues),
		expstylevalues={expstylevalues};
	end
end
if exist(options,'expdisp'),
	expdispvalues=getfieldvalue(options,'expdisp');
	%ischar if only one expstyle -> create a cell
	if ischar(expdispvalues),
		expdispvalues={expdispvalues};
	end
	for i=1:length(expdispvalues)
		expdispvaluesarray{end+1}=expdispvalues{i};
		if (length(expstylevalues)>=i),
			expstylevaluesarray{end+1}=expstylevalues{i};
		else
			expstylevaluesarray{end+1}='g-';
		end
	end
end
options=changefieldvalue(options,'expstyle',expstylevaluesarray);
options=changefieldvalue(options,'expdisp',expdispvaluesarray);

%latlonnumbering
if exist(options,'latlonclick'),
	if strcmpi(getfieldvalue(options,'latlonclick'),'on')
		options=changefieldvalue(options,'latlonclick',1);
	end
end

%north arrow
if exist(options,'northarrow'),
	if strcmpi(getfieldvalue(options,'northarrow'),'on')
		%default values
		Lx=max(md.y)-min(md.y);
		Ly=max(md.y)-min(md.y);
		%default values
		options=changefieldvalue(options,'northarrow',[min(md.x)+1/6*Lx   min(md.y)+5/6*Ly   1/15*Ly   0.25   1/250*Ly]);
	end
end

%scale ruler
if exist(options,'scaleruler'),
	if strcmpi(getfieldvalue(options,'scaleruler'),'on')
		%default values
		Lx=max(md.y)-min(md.y);
		Ly=max(md.y)-min(md.y);
		%default values
		options=changefieldvalue(options,'scaleruler',[min(md.x)+6/8*Lx   min(md.y)+1/10*Ly   10^(ceil(log10(Lx)))/5 floor(Lx/100) 5]);
	end
end
