%TIDALLOVE class definition
%
%   Usage:
%      tidallove=tidallove();

classdef tidallove
	properties (SetAccess=public) 
		h          = 0; 
		k          = 0; 
		k2secular  = 0; 
	end
	methods
		function self = tidallove(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = setdefaultparameters(self) % {{{
		
			%tidal love numbers: 
			self.h=0.6149; %degree 2
			self.k=0.3055; % degree 2

			%secular fluid love number: 
			self.k2secular=0.942; 

		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			if ~ismember('SealevelriseAnalysis',analyses) | (strcmp(solution,'TransientSolution') & md.transient.istidallove==0), 
				return; 
			end

			md = checkfield(md,'fieldname','tidallove.h','NaN',1,'Inf',1);
			md = checkfield(md,'fieldname','tidallove.k','NaN',1,'Inf',1);
			md = checkfield(md,'fieldname','tidallove.k2secular','NaN',1,'Inf',1);

		end % }}}
		function list=defaultoutputs(self,md) % {{{
			list = {};
		end % }}}
		function disp(self) % {{{
			disp(sprintf('   tidallove parameters:'));

			fielddisplay(self,'h','tidal load Love number (deg 2)');
			fielddisplay(self,'k','tidal load Love number (deg 2)');
			fielddisplay(self,'k2secular','secular fluid Love number');

		end % }}}
		function marshall(self,prefix,md,fid) % {{{
			WriteData(fid,prefix,'name','md.solidearth.love.model','data',2,'format','Integer');
			WriteData(fid,prefix,'object',self,'fieldname','h','name','md.solidearth.love.h','format','Double','mattype',1);
			WriteData(fid,prefix,'object',self,'fieldname','k','name','md.solidearth.love.k','format','Double','mattype',1);
			WriteData(fid,prefix,'object',self,'fieldname','k2secular','name','md.solidearth.love.k2secular','format','DoubleMat','mattype',1);
		end % }}}
		function savemodeljs(self,fid,modelname) % {{{
			writejs1Darray(fid,[modelname '.tidallove.h'],self.h);
			writejs1Darray(fid,[modelname '.tidallove.k'],self.k);
			writejs1Darray(fid,[modelname '.tidallove.k2secular'],self.k2secular);
		end % }}}
		function self = extrude(self,md) % {{{
		end % }}}
	end
end
