%SURFACELOAD class definition
%
%   Usage:
%      surfaceload=surfaceload();

classdef surfaceload
	properties (SetAccess=public) 
		icethicknesschange     = [];
		waterheightchange      = [];
		other                  = [];
	end
	methods
		function self = surfaceload(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = setdefaultparameters(self) % {{{
		
			icethicknesschange=[];
			waterheightchange=[];
			other=[];
		
		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			if ~ismember('SealevelriseAnalysis',analyses) | (strcmp(solution,'TransientSolution') & md.transient.issurfaceload==0), 
				return; 
			end
			if ~isempty(self.icethicknesschange),
				md = checkfield(md,'fieldname','solidearth.surfaceload.icethicknesschange','timeseries',1,'NaN',1,'Inf',1);
			end
			if ~isempty(self.waterheightchange),
				md = checkfield(md,'fieldname','solidearth.surfaceload.waterheightchange','timeseries',1,'NaN',1,'Inf',1);
			end
			if ~isempty(self.other),
				md = checkfield(md,'fieldname','solidearth.surfaceload.other','timeseries',1,'NaN',1,'Inf',1);
			end

			%cross check that whereever we have an ice load, the mask is <0 on each vertex:  legacy
			%pos=find(self.deltathickness);
			%maskpos=md.mask.ice_levelset(md.mesh.elements(pos,:)); 
			%[els,vertices]=find(maskpos>0);
			%if length(els),
			%	warning('solidearth checkconsistency fail: there are elements with ice loads where some vertices are not on the ice!');
			%end

		end % }}}
		function disp(self) % {{{
			disp(sprintf('   surfaceload:'));

			fielddisplay(self,'icethicknesschange','thickness change: ice height equivalent [mIce/yr]');
			fielddisplay(self,'waterheightchange','water height change: water height equivalent [mWater/yr]');
			fielddisplay(self,'other','other loads (sediments) [kg/m^2/yr]');

		end % }}}
		function marshall(self,prefix,md,fid) % {{{

			if isempty(self.icethicknesschange), self.icethicknesschange=zeros(md.mesh.numberofelements+1,1); end
			if isempty(self.waterheightchange), self.waterheightchange=zeros(md.mesh.numberofelements+1,1); end
			if isempty(self.other), self.other=zeros(md.mesh.numberofelements+1,1); end
			WriteData(fid,prefix,'object',self,'fieldname','icethicknesschange','name','md.solidearth.surfaceload.icethicknesschange',...
				'format','DoubleMat','mattype',2,'timeserieslength',md.mesh.numberofelements+1,'yts',md.constants.yts);
			WriteData(fid,prefix,'object',self,'fieldname','waterheightchange','name','md.solidearth.surfaceload.waterheightchange',...
				'format','DoubleMat','mattype',2,'timeserieslength',md.mesh.numberofelements+1,'yts',md.constants.yts);
			WriteData(fid,prefix,'object',self,'fieldname','other','name','md.solidearth.surfaceload.other',...
				'format','DoubleMat','mattype',2,'timeserieslength',md.mesh.numberofelements+1,'yts',md.constants.yts);

		end % }}}
		function savemodeljs(self,fid,modelname) % {{{
		
			writejs1Darray(fid,[modelname '.surfaceload.icethicknesschange'],self.icethicknesschange);
			writejs1Darray(fid,[modelname '.surfaceload.waterheightchange'],self.waterheightchange);
			writejs1Darray(fid,[modelname '.surfaceload.other'],self.other);
		end % }}}
		function self = extrude(self,md) % {{{
		end % }}}
	end
end
