%LOADINGLOVE class definition
%
%   Usage:
%      love=loadinglove();

classdef loadinglove
	properties (SetAccess=public) 
		
		%regular love numbers:
		h                 = 0; %provided by PREM model
		k                 = 0; %idem
		l                 = 0; %idem
		
		%tidal love numbers for computing rotational feedback:
		th          = 0; 
		tk          = 0; 
		tk2secular  = 0; 

	end
	methods
		function self = loadinglove(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = setdefaultparameters(self) % {{{
			
			%tidal love numbers: 
			self.th=0.6149; %degree 2
			self.tk=0.3055; % degree 2

			%secular fluid love number: 
			self.tk2secular=0.942; 

		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			if ~ismember('SealevelriseAnalysis',analyses) | (strcmp(solution,'TransientSolution') & md.transient.islove==0), 
				return; 
			end

			md = checkfield(md,'fieldname','solidearth.love.h','NaN',1,'Inf',1);
			md = checkfield(md,'fieldname','solidearth.love.k','NaN',1,'Inf',1);
			md = checkfield(md,'fieldname','solidearth.love.l','NaN',1,'Inf',1);
			
			
			md = checkfield(md,'fieldname','solidearth.love.th','NaN',1,'Inf',1);
			md = checkfield(md,'fieldname','solidearth.love.tk','NaN',1,'Inf',1);
			md = checkfield(md,'fieldname','solidearth.love.tk2secular','NaN',1,'Inf',1);

			%check that love numbers are provided at the same level of accuracy: 
			if (size(self.h,1)~=size(self.k,1) | size(self.h,1)~=size(self.l,1)),
				error('love error message: love numbers should be provided at the same level of accuracy');
			end


		end % }}}
		function list=defaultoutputs(self,md) % {{{
			list = {};
		end % }}}
		function disp(self) % {{{
			disp(sprintf('   loadinglove parameters:'));

			fielddisplay(self,'h','load Love number for radial displacement');
			fielddisplay(self,'k','load Love number for gravitational potential perturbation');
			fielddisplay(self,'l','load Love number for horizontal displacements');

			fielddisplay(self,'th','tidal load Love number (deg 2)');
			fielddisplay(self,'tk','tidal load Love number (deg 2)');
			fielddisplay(self,'tk2secular','secular fluid Love number');

		end % }}}
		function marshall(self,prefix,md,fid) % {{{
			
			WriteData(fid,prefix,'name','md.solidearth.love.model','data',1,'format','Integer');

			WriteData(fid,prefix,'object',self,'fieldname','h','name','md.solidearth.love.h','format','DoubleMat','mattype',1);
			WriteData(fid,prefix,'object',self,'fieldname','k','name','md.solidearth.love.k','format','DoubleMat','mattype',1);
			WriteData(fid,prefix,'object',self,'fieldname','l','name','md.solidearth.love.l','format','DoubleMat','mattype',1);

			WriteData(fid,prefix,'object',self,'fieldname','th','name','md.solidearth.love.th','format','Double');
			WriteData(fid,prefix,'object',self,'fieldname','tk','name','md.solidearth.love.tk','format','Double');
			WriteData(fid,prefix,'object',self,'fieldname','tk2secular','name','md.solidearth.love.tk2secular','format','Double');


		end % }}}
		function savemodeljs(self,fid,modelname) % {{{
			writejs1Darray(fid,[modelname '.love.h'],self.h);
			writejs1Darray(fid,[modelname '.love.k'],self.k);
			writejs1Darray(fid,[modelname '.love.l'],self.l);
		end % }}}
		function self = extrude(self,md) % {{{
		end % }}}
	end
end
