import numpy as np


class histogram_bin_uncertain(object):
    '''
    HISTOGRAM_BIN_UNCERTAIN class definition

    Usage:
        [hbu] = histogram_bin_uncertain(
            'descriptor', descriptor,
            'pairs_per_variable', pairs_per_variable,
            'abscissas', abscissas,
            'counts', counts
            )

        where the required args are:
            descriptor          (char, description, '')
            pairs_per_variable  (double list, [])
            abscissas           (double list, [])
            counts              (int list, [])

    NOTE: A call to the constructor with zero arguments will return a default 
    instance; one argument of the class copies the instance; three or more 
    arguments constructs a new instance from the arguments.
    '''

    def __init__(self): #{{{
        self.descriptor = ''
        self.pairs_per_variable = []
        self.abscissas = []
        self.counts = []
    #}}}

    @staticmethod
    def histogram_bin_uncertain(*args): #{{{
        nargin = len(args)

        # create a default object
        if nargin == 0:
            return histogram_bin_uncertain()

        # copy the object
        elif nargin == 1:
            if isinstance(args[0], histogram_bin_uncertain):
                hbu = args[0]
            else:
                raise Exception("Object {} is a {} class object, not 'histogram_bin_uncertain'.".format(str(args[0]), str(type(args[0]))))

        elif nargin == 2 or nargin == 3:
            raise Exception("Construction of 'histogram_bin_uncertain' class object requires at least {} inputs.".format(4))

        # create the object from the input
        elif nargin == 4:
            hbu = histogram_bin_uncertain()

            #recover options:
            options = pairoptions(*args)

            #initialize fields:
            hbu.descriptor          = options.getfieldvalue('descriptor')
            hbu.pairs_per_variable  = options.getfieldvalue('pairs_per_variable')
            hbu.abscissas           = options.getfieldvalue('abscissas')
            hbu.counts              = options.getfieldvalue('counts')

        else:
            raise Exception("Construction of histogram_bin_uncertain class object requires either (1) no arguments, (2) a histogram_bin_uncertain instance to copy from, or (3) a descriptor and pairs per variable, abscissas, and counts lists")
