% %  definition for the histogram_bin_uncertain class.
%
%  [hbu]=histogram_bin_uncertain(varargin)
%
%  where the required varargin are:
%    descriptor    (char, description, '')
%    pairs_per_variable          (double vector, [])
%    abscissas          (double vector, [])
%    counts          (int vector, [])
%
%  note that zero arguments constructs a default instance; one
%  argument of the class copies the instance; and three or more
%  arguments constructs a new instance from the arguments.
%
classdef histogram_bin_uncertain
    properties
        descriptor='';
		pairs_per_variable=[];
        abscissas = [];
        counts = [];
    end

    methods
        function [hbu]=histogram_bin_uncertain(varargin) % {{{

            switch nargin
                case 0 %  create a default object
                case 1 %  copy the object
                    if isa(varargin{1},'histogram_bin_uncertain')
                        hbu=varargin{1};
                    else
                        error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
                            inputname(1),class(varargin{1}),'histogram_bin_uncertain');
                    end
                case {2,3} %  not enough arguments
                    error('Construction of ''%s'' class object requires at least %d inputs.',...
                        'histogram_bin_uncertain',4)
                case 4 % 
					%  create the object from the input
					hbu = histogram_bin_uncertain; 
					hbu.descriptor=varargin{1};
					hbu.pairs_per_variable=varargin{2};
					hbu.abscissas=varargin{3};
					hbu.counts=varargin{4};

                otherwise 
					error('Construction of histogram_bin_uncertain class object requires three arguments, descriptor, abscissas and counts');
            end

        end % }}}
		function md=checkconsistency(self,md,solution,analyses) % {{{
		end % }}}
        function []=disp(hbu) % {{{

%  display the object

            disp(sprintf('\n'));
            for i=1:numel(hbu)
                disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
                    class(hbu),inputname(1),string_dim(hbu,i)));
                disp(sprintf('    descriptor: ''%s'''  ,hbu(i).descriptor));
                disp(sprintf('          pairs_per_variable: %g'      ,hbu(i).pairs_per_variable));
                disp(sprintf('          abscissas: %g'      ,hbu(i).abscissas));
                disp(sprintf('        counts: %g'      ,hbu(i).counts));
            end

        end % }}}
        function [desc]  =prop_desc(hbu,dstr) % {{{ 
            desc=cell(1,numel(hbu));
            for i=1:numel(hbu)
                if ~isempty(hbu(i).descriptor)
                    desc(i)=cellstr(hbu(i).descriptor);
                elseif ~isempty(inputname(1))
                    desc(i)=cellstr([inputname(1) string_dim(hbu,i,'vector')]);
                elseif exist('dstr','var')
                    desc(i)=cellstr([dstr         string_dim(hbu,i,'vector')]);
                else
                    desc(i)=cellstr(['hbu'        string_dim(hbu,i,'vector')]);
                end
            end
            desc=allempty(desc);
        end  %}}}
        function [initpt]=prop_initpt(hbu) % {{{
            initpt=[];
        end % }}}
        function [lower] =prop_lower(hbu) % {{{
            lower=[];
        end % }}}
        function [upper] =prop_upper(hbu) % {{{
            upper=[];
        end % }}}
        function [mean]  =prop_mean(hbu) % {{{
            mean=[];
        end % }}}
        function [stddev]=prop_stddev(hbu) % {{{
            stddev=[];
        end % }}}
        function [initst]=prop_initst(hbu) % {{{ 
            initst=[];
        end % }}}
        function [stype] =prop_stype(hbu) % {{{
            stype={};
        end % }}}
        function [scale] =prop_scale(hbu) % {{{
            scale=[]; 
        end % }}}
		function [abscissas] =prop_abscissas(hbu) % {{{
		abscissas=[]; 
		for i=1:numel(hbu)
			abscissas=[abscissas hbu(i).abscissas];
		end
		abscissas=allequal(abscissas,-Inf);

        end % }}}
		function [pairs_per_variable] =prop_pairs_per_variable(hbu) % {{{
			pairs_per_variable=zeros(1,numel(hbu));
            for i=1:numel(hbu)
                pairs_per_variable(i)=hbu(i).pairs_per_variable;
            end
            pairs_per_variable=allequal(pairs_per_variable,-Inf);
        end % }}}
   		function [counts] =prop_counts(hbu) % {{{
		counts=[]; 
		for i=1:numel(hbu)
			counts=[counts hbu(i).counts];
		end
		counts=allequal(counts,-Inf);

        end % }}}
		function scaled=isscaled(self) % {{{
			if strncmp(self.descriptor,'scaled_',7),
				scaled=1;
			else
				scaled=0;
			end
		end % }}}
	end
    methods (Static)
        function []=dakota_write(fidi,dvar) % {{{

%  collect only the variables of the appropriate class

            hbu=struc_class(dvar,'histogram_bin_uncertain');

%  write variables

            vlist_write(fidi,'histogram_bin_uncertain','hbu',hbu);
        end % }}}
    end
end
