function string = epsg2proj(epsg)
%FUNCTION EPSG2PROJ - uses gdalsrsinfo to provide PROJ.4 compatible string from 
%EPSG code
%
%   Usage:
%      proj4string = epsg2proj(4326);
%
%   Example:
%      proj4string = epsg2proj(4326);
%      return proj4string='+proj=longlat +datum=wgs84 +no_defs'
%
	% First, get GDAL version
	[s,r]=system(['gdalsrsinfo --version | awk ''{print $2}'' | cut -d ''.'' -f1']);

	if s~=0, 
		error(r);
	end

	version_major=str2num(r);

	[s,r]=system(['gdalsrsinfo epsg:' num2str(epsg) ' | grep PROJ.4 | tr -d ''\n'' | sed ''s/PROJ.4 : //''']);

	if s~=0, 
		error(r);
	end

	if version_major==1,
		r=r(2:end-2);
	end

	string=(r);
