%ISMIP6 class definition
%
%   Usage:
%      is6 = ismip6('root',rootdir,'dirs',listdirectories);
%   Example: 
%      is6 = ismip6('root','./gis/','dirs',{'UVW','ISSM'});

classdef ismip6 < handle
	properties (SetAccess=public) %Model fields
		
		root = ''; %where are the files for CMIP5
		n   = 0;   %number of files
		directories   = {};   %directories where the files are
		experiments   = {};   %names of experiments

	end
	methods
		function self = ismip6(varargin) % {{{

			if nargin==0, 
				self=setdefaultparameters(self);
			else 
				self=setdefaultparameters(self);

				options=pairoptions(varargin{:});

				self.root=getfieldvalue(options,'root');
				self.directories=getfieldvalue(options,'directories');
				self.n=length(self.directories);

				%verify the directories exist: 
				for i=1:self.n,
					if ~exist([self.root '/' self.directories{i}],'dir'),
						error(['ismip6  constructor error: ' self.root '/' self.directories{i} ' does not exist']);
					end
				end

				%figure out names of experiments: 
				self.experiments=self.directories;
				for i=1:self.n,
					dir=self.directories{i};
					ind=findstr(dir,'exp');
					name=dir(1:ind-2);
					name=strrep(name,'/','-');
					self.experiments{i}=name;
				end

			end
		end
		%}}}
		function self = setdefaultparameters(self) % {{{
		end
		%}}}
		function disp(self) % {{{
			disp('   CMIP5 Ocean MIP:');

				fielddisplay(self,'n','number of files');
				fielddisplay(self,'root','where are the files for ISMIP6');
				fielddisplay(self,'directories','IMSIP6 directories');
		end % }}}
		function listexp(self) % {{{
			disp('ISMIP6  list of experiments:');
			for i=1:self.n,
				disp(['   ' self.experiments{i}]);
			end

		end % }}}
	end 
end
