import shlex
import subprocess

def epsg2proj(epsg): #{{{
    '''
    FUNCTION EPSG2PROJ - uses gdalsrsinfo to provide PROJ.4 compatible string 
    from EPSG code

    Usage:
        proj4string = epsg2proj(4326)

    Example:
        proj4string = epsg2proj(4326)
        return proj4string = '+proj=longlat +datum=wgs84 +no_defs'

    TODO:
        - Implement try/catch for proc.communicate()
            - In case of Python 2, except socket.timeout: https://docs.python.org/3/library/socket.html?highlight=socket%20timeout#socket.timeout
            - In case of Python 3, except TimeoutExpired: https://docs.python.org/3/library/subprocess.html#subprocess.SubprocessError
    '''
    args = 'gdalsrsinfo epsg:%s | grep PROJ.4 | sed "s/PROJ.4 : //"' % epsg
    proc = subprocess.Popen(args, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    outs, errs = proc.communicate()
    
    if errs != None:
        raise RuntimeError('epsg2proj: call to gdalsrsinfo failed: %s' % errs)

    return outs
#}}}
