function string = epsg2proj(epsg)
%FUNCTION EPSG2PROJ - uses gdalsrsinfo to provide PROJ.4 compatible string from 
%EPSG code
%
%   Usage:
%      proj4string = epsg2proj(4326);
%
%   Example:
%      proj4string = epsg2proj(4326);
%      return proj4string='+proj=longlat +datum=wgs84 +no_defs'
%

	[s,r]=system(['gdalsrsinfo epsg:' num2str(epsg) ' | grep PROJ.4 | sed "s/PROJ.4 : //"']);

	if s~=0, 
		error(r);
	end
	string=(r);
