from copy import deepcopy
from helpers import *
from MatlabFuncs import *
from normal_uncertain import *
from qmupart2npart import *
from uniform_uncertain import *


def QmuSetupVariables(md, variables):
    #get descriptor
    descriptor = variables.descriptor

    #decide whether this is a distributed variable, which will drive whether we expand it into npart values,
    #or if we just carry it forward as is.

    dvar = []

    #ok, key off according to type of descriptor:
    if strncmp(descriptor, 'scaled_', 7):
        #we have a scaled variable, expand it over the partition. First recover the partition.
        partition = variables.partition
        #figure out number of partitions
        npart=qmupart2npart(partition)

        if isinstance(variables, uniform_uncertain):
            nlower=len(variables.lower)
            nupper=len(variables.upper)
            if nlower != npart or nupper != npart:
                raise RuntimeError('QmuSetupVariables error message: upper and lower fields should be same size as the number of partitions')
        elif isinstance(variables, normal_uncertain):
            nstddev=len(variables.stddev)
            nmean=len(variables.mean)
            if nstddev != npart or nmean != npart:
                raise RuntimeError('QmuSetupVariables error message: stddev and mean fields should be same size as the number of partitions')

        #ok, dealing with semi-discrete distributed variable. Distribute according to how many
        #partitions we want
        for j in range(npart):
            dvar.append(deepcopy(variables))

            # text parsing in dakota requires literal "'identifier'" not just "identifier"
            dvar[-1].descriptor = "'" + str(variables.descriptor) + '_' + str(j + 1) + "'"

            if isinstance(variables, uniform_uncertain):
                dvar[-1].lower = variables.lower[j]
                dvar[-1].upper = variables.upper[j]
            elif isinstance(variables, normal_uncertain):
                dvar[-1].stddev = variables.stddev[j]
                dvar[-1].mean = variables.mean[j]
    else:
        dvar.append(deepcopy(variables))

        # text parsing in dakota requires literal "'identifier'" not just "identifier"
        dvar[-1].descriptor = "'" + str(variables.descriptor) + "'"

    return dvar
