function dvar=QmuSetupVariables(md,dvar,variables)

%get descriptor
descriptor=variables.descriptor;

%decide whether this is a distributed variable, which will drive whether we expand it into npart values,
%or if we just carry it forward as is. 

%ok, key off according to type of descriptor:
if strncmp(descriptor,'scaled_',7),
	%we have a scaled variable, expand it over the partition. First recover the partition: 
	partition=variables.partition;
	%figure out number of partitions: 
	npart=qmupart2npart(partition)

	if isa(variables,'uniform_uncertain'),
		nlower=length(variables.lower); nupper=length(variables.upper);
		if (nlower ~= npart || nupper ~=npart),
			error('QmuSetupVariables error message: upper and lower fields should be same size as the number of partitions');
		end
	elseif isa(variables,'normal_uncertain'),
		nstddev=length(variables.stddev);
		nmean=length(variables.mean);
		if (nstddev ~= npart || nmean ~=npart),
			error('QmuSetupVariables error message: stddev and mean fields should be same size as the number of partitions');
		end
	end

	%ok, dealing with semi-discrete distributed variable. Distribute according to how many 
	%partitions we want
	for j=1:npart,
		dvar(end+1)           =variables;
		dvar(end  ).descriptor=sprintf('%s_%d',variables.descriptor,j);
		if isa(variables,'uniform_uncertain'),
			dvar(end  ).lower=variables.lower(j);
			dvar(end  ).upper=variables.upper(j);
		elseif isa(variables,'normal_uncertain'),
			dvar(end  ).stddev=variables.stddev(j);
			dvar(end  ).mean=variables.mean(j);
		end
	end

else
	dvar(end+1)=variables;
end
