function BuildQueueingScriptgreenplanet(md,executionpath,codepath)
%BUILDQUEUEINGSCRIPTGEMINI - ...
%
%   Usage:
%      BuildQueueingScriptgreenplanet(md,executionpath,codepath)

scriptname=[md.name '.queue'];

%check queue names: 
if strcmpi(md.cluster,'greenplanet'),
	available_queues={'rignot','default'};
	if  ~ismemberi(md.queue,available_queues),
		error('BuildQueueingScriptgreenplanet error message: availables queues are rignot and default');
	end 

	if strcmpi(md.queue,'rignot'),
		if md.np>80,
			error('BuildQueueingScriptgreenplaneterror error message: debug queue only allows for 80 cpus max');
		end
		
		if md.time>60,
			error('BuildQueueingScriptgreenplaneterror error message: debug queue only allows for 60 minute runs');
		end
	end
end

fid=fopen(scriptname,'w');
if fid==-1,
	error(['BuildQueueingScriptgreenplaneterror message: could not open ' scriptname ' file for ascii writing']);
end

fprintf(fid,'#!/bin/csh\n');
fprintf(fid,'#PBS -N %s\n',md.name);
fprintf(fid,'#PBS -l nodes=%i:ppn=%i\n',md.np/8,8);
fprintf(fid,'#PBS -q %s\n',md.queue);
fprintf(fid,'#PBS -m bea\n');
fprintf(fid,'#PBS -M eric.larour@jpl.nasa.gov\n');
fprintf(fid,'#PBS -l walltime=%i\n',md.time*60); %walltime is in seconds.

fprintf(fid,'cd $PBS_O_WORKDIR\n');
fprintf(fid,'mpirun -machinefile $PBS_NODEFILE -np %i %s/%s.exe %s %s.bin %s.outbin %s.lock > %s.outlog',md.np,codepath,AnalysisTypeFromEnum(md.analysis_type),executionpath,md.name,md.name,md.name,md.name);

fclose(fid);
