#!/bin/bash
set -eu


## Constants
#
VER="6.0.0"

PETSC_ROOT="${ISSM_DIR}/externalpackages/petsc/install"

BLASLAPACK_ROOT="${PETSC_ROOT}"
CURL_ROOT="${ISSM_DIR}/externalpackages/curl/install"
GDAL_ROOT="${ISSM_DIR}/externalpackages/gdal/install"
HDF5_ROOT="${PETSC_ROOT}"
NETCDF_ROOT="${ISSM_DIR}/externalpackages/netcdf/install"
PROJ_ROOT="${ISSM_DIR}/externalpackages/proj/install"
ZLIB_ROOT="${PETSC_ROOT}"

GDAL_LIBRARY="${GDAL_ROOT}/lib/libgdal.a;${NETCDF_ROOT}/lib/libnetcdf.a;${HDF5_ROOT}/lib/libhdf5_hl.a;${HDF5_ROOT}/lib/libhdf5.a;${PROJ_ROOT}/lib/libproj.a;${ZLIB_ROOT}/lib/libz.a;-L/usr/lib/x86_64-linux-gnu;-lpthread;-lm;-lrt;-ldl;${CURL_ROOT}/lib/libcurl.a;/usr/lib/x86_64-linux-gnu/libssl.a;/usr/lib/x86_64-linux-gnu/libcrypto.a;/usr/lib/x86_64-linux-gnu/libsqlite3.a;/usr/lib/x86_64-linux-gnu/libexpat.a;-lstdc++" # Determined by running `$GDAL_ROOT/bin/gdal-config --dep-libs`, removing duplicate libs, then adding libmpicxx as, otherwise, various symbols in libgdal are undefined (compiled with mpicxx)
NETCDF_LIBRARY="${NETCDF_ROOT}/lib/libnetcdf.a;-L/usr/lib/x86_64-linux-gnu;-lm;${CURL_ROOT}/lib/libcurl.a;${HDF5_ROOT}/lib/libhdf5_hl.a;${HDF5_ROOT}/lib/libhdf5.a;${ZLIB_ROOT}/lib/libz.a;/usr/lib/x86_64-linux-gnu/libssl.a;/usr/lib/x86_64-linux-gnu/libcrypto.a;-ldl" # Determined by running `$NETCDF_ROOT/bin/nc-config --libs`

# Environment
#
export CC=mpicc

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/gmt-${VER}.tar.gz" "gmt-${VER}.tar.gz"

# Unpack source
tar -zxvf gmt-${VER}.tar.gz

# Cleanup
rm -rf install src
mkdir install src

# Move source to 'src' directory
mv gmt-${VER}/* src
rm -rf gmt-${VER}

# Copy custom configuration files
cp ./configs/6.0/linux/cmake/ConfigUser.static.cmake ./src/cmake/ConfigUser.cmake
cp ./configs/6.0/linux/static/cmake/modules/FindGSHHG.cmake ./src/cmake/modules

# Configure
cd src
mkdir build
cd build

# NOTE:
# - There is a CMake variable named CURL_ROOT in src/cmake/ConfigUser.cmake
#	that, ostensibly, allows for supplying the path to curl when it is in a
#	non-standard location. That said, newer versions of CMake will ignore said
#	variable and instead try to find curl itself. Passing in the two options
#	below overrides this behavior.
# - The CMake modules used to find and probe the BLAS and LAPACK libraries do
#	not seem to handle the situation where BLAS_LIBRARY and LAPACK_LIBRARY are
#	set but we are working with static libraries
#	(see customized ConfigUser.static.cmake). Using BLAS_LIBRARIES and
#	LAPACK_LIBRARIES is a workaround.
#
cmake \
	-DBLAS_LIBRARIES="${BLASLAPACK_ROOT}/lib/libfblas.a;-L/usr/lib/x86_64-linux-gnu;-lgfortran" \
	-DCURL_LIBRARY="${CURL_ROOT}/lib" \
	-DCURL_INCLUDE_DIR="${CURL_ROOT}/include" \
	-DLAPACK_LIBRARIES="${BLASLAPACK_ROOT}/lib/libflapack.a;-L/usr/lib/x86_64-linux-gnu;-lgfortran" \
	-DGDAL_LIBRARY="${GDAL_LIBRARY}" \
	-DNETCDF_LIBRARY="${NETCDF_LIBRARY}" \
	..

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi
