/*!\file SealevelMasks.h
 * \brief: header file for SealevelMask object
 */

#ifndef _SEALEVELMASKS_H_
#define _SEALEVELMASKS_H_

/*Headers:*/

class SealevelMasks {

	public: 

		bool*       isiceonly;
		bool*       isfullyfloating;
		bool*       notfullygrounded;
		bool*       isoceanin; 
		
		/*SealevelMasks constructors, destructors :*/
		SealevelMasks(int nel){
			/*allocate fields:*/
			this->isiceonly=xNew<bool>(nel);
			this->isfullyfloating=xNew<bool>(nel);
			this->notfullygrounded=xNew<bool>(nel);
			this->isoceanin=xNew<bool>(nel);
		};
		~SealevelMasks(){
			xDelete<bool>(this->isiceonly);
			xDelete<bool>(this->isfullyfloating);
			xDelete<bool>(this->notfullygrounded);
			xDelete<bool>(this->isoceanin);
		};
};
#endif  /* _SEALEVELMASKS_H_ */
