#ifndef _CONTAINER_INPUTS2_H_
#define _CONTAINER_INPUTS2_H_

/*forward declarations */
class Input2;
class SegInput2;
class TriaInput2;
class PentaInput2;
class TransientInput2;
class ElementInput2;
class DatasetInput2;
class ArrayInput2;
class ControlInput2;
class Parameters;
#include "../../shared/shared.h"

#define NUMINPUTS InputsENDEnum - InputsSTARTEnum -1

/*!\brief Declaration of Inputs class.
 *
 * Declaration of Inputs class.  Inputs are a static array of Input objects.
 */
class Inputs2{

	private:
		/*Private fields*/
		Input2* inputs[NUMINPUTS];
		int     numberofelements_local;
		int     numberofvertices_local;

		/*Private functions*/
		int     EnumToIndex(int enum_in);

	public:

		/*constructors, destructors*/
		Inputs2();
		Inputs2(int nbe,int nbv);
		~Inputs2();

		/*numerics*/
		void     AddInput(Input2* in_input);
		void     ChangeEnum(int enumtype,int new_enumtype);
		void     Configure(Parameters* parameters);
		Inputs2* Copy(void);
		int      DeleteInput(int enum_type);
		void     DuplicateInput(int original_enum,int new_enum);
		void     DeepEcho(void);
		void     Echo(void);
		bool     Exist(int enum_type);
		void     GetInputsInterpolations(int* pnuminputs,int** pinterpolations,int** penum);
		void             GetArray(int enum_in,int row,IssmDouble** pvalues,int* pN);
		void             GetArrayPtr(int enum_in,int row,IssmDouble** pvalues,int* pN);
		SegInput2*       GetSegInput(int enum_type);
		TriaInput2*      GetTriaInput(int enum_type);
		TriaInput2*      GetTriaInput(int enum_type,IssmDouble time);
		TriaInput2*      GetTriaInput(int enum_in,IssmDouble start_time,IssmDouble end_time,int averaging_method);
		PentaInput2*     GetPentaInput(int enum_type);
		PentaInput2*     GetPentaInput(int enum_type,IssmDouble time);
		TransientInput2* GetTransientInput(int enum_type);
		ElementInput2*   GetControlInput2Data(int enum_type,const char* data);
		DatasetInput2*   GetDatasetInput2(int enum_type);
		ControlInput2*   GetControlInput2(int enum_type);
		void  Marshall(char** pmarshalled_data, int* pmarshalled_data_size, int marshall_direction);
		int   GetInputObjectEnum(int enum_type);
		void  GetInputValue(bool* pvalue,int enum_in,int index);
		void  GetInputValue(int*  pvalue,int enum_in,int index);
		void  GetInputValue(IssmDouble*  pvalue,int enum_in,int index);
		void  ResultInterpolation(int* pinterpolation,int*nodesperelement,int* parray_size, int output_enum);
		void  SetInput(int enum_in,int index,bool value);
		void  SetInput(int enum_in,int index,int value);
		void  SetDoubleInput(int enum_in,int index,IssmDouble value);
		void  SetTransientInput(int enum_in,IssmDouble* times,int numtimes);
		TransientInput2* SetDatasetTransientInput(int enum_in,int id,IssmDouble* times,int numtimes);
		void  SetArrayInput(int enum_in,int row,IssmDouble* layers,int numlayers);
		void  SetTriaControlInput(int enum_in,int layout,int interpolation,int id,int numindices,int* indices,IssmDouble* values,IssmDouble* values_min,IssmDouble* values_max);
		void  SetTriaControlInputGradient(int enum_in,int interpolation,int numindices,int* indices,IssmDouble* values);
		void  SetTriaControlInputGradient(int enum_in,int interpolation,int numindices,int* indices,IssmDouble* values,int n);
		void  SetTriaDatasetInput(int enum_in,int id,int interpolation,int numindices,int* indices,IssmDouble* values);
		void  SetTriaInput(int enum_in,int interpolation,int row,IssmDouble values);
		void  SetTriaInput(int enum_in,int interpolation,int numindices,int* indices,IssmDouble* values);
		void  SetTriaInput(int enum_in,int interpolation,int row,int numindices,IssmDouble* values);
		void  SetPentaControlInput(int enum_in,int layout,int interpolation,int id,int numindices,int* indices,IssmDouble* values,IssmDouble* values_min,IssmDouble* values_max);
		void  SetPentaControlInputGradient(int enum_in,int interpolation,int numindices,int* indices,IssmDouble* values);
		void  SetPentaDatasetInput(int enum_in,int id,int interpolation,int numindices,int* indices,IssmDouble* values);
		void  SetPentaInput(int enum_in,int interpolation,int row,IssmDouble values);
		void  SetPentaInput(int enum_in,int interpolation,int numindices,int* indices,IssmDouble* values);
		void  SetPentaInput(int enum_in,int interpolation,int row,int numindices,IssmDouble* values);
};

#endif //ifndef _INPUTS_H_
