/*!\file DoubleInput2.c
 * \brief: implementation of the DoubleInput2 object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "../../shared/shared.h"
#include "./DoubleInput2.h"

/*DoubleInput2 constructors and destructor*/
DoubleInput2::DoubleInput2(){/*{{{*/
	this->size   = -1;
	this->values = NULL;
}
/*}}}*/
DoubleInput2::DoubleInput2(int size_in){/*{{{*/
	_assert_(size_in>0);
	_assert_(size_in<1e11);
	this->size   = size_in;
	this->values = xNew<IssmDouble>(size_in);
}
/*}}}*/
DoubleInput2::~DoubleInput2(){/*{{{*/
	xDelete<IssmDouble>(this->values);
}
/*}}}*/

/*Object virtual functions definitions:*/
Input2* DoubleInput2::copy() {/*{{{*/

	DoubleInput2* output = new DoubleInput2(this->size);
	xMemCpy<IssmDouble>(output->values,this->values,this->size);

	return output;
}
/*}}}*/
void DoubleInput2::DeepEcho(void){/*{{{*/

	_printf_("DoubleInput2 Echo:\n");
	_printf_("   Size:          "<<size<<"\n");
	printarray(this->values,this->size);
	//_printf_(setw(15)<<"   DoubleInput2 "<<setw(25)<<left<<EnumToStringx(this->enum_type)<<" "<<(value?"true":"false") << "\n");
}
/*}}}*/
void DoubleInput2::Echo(void){/*{{{*/
	this->DeepEcho();
}
/*}}}*/
int  DoubleInput2::Id(void){ return -1; }/*{{{*/
/*}}}*/
void DoubleInput2::Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction){ /*{{{*/

	MARSHALLING_ENUM(DoubleInput2Enum);

	MARSHALLING(this->size);
	if(this->size > 0){
		MARSHALLING_DYNAMIC(this->values,IssmDouble,this->size)
	}
	else this->values = NULL;

}
/*}}}*/
int  DoubleInput2::ObjectEnum(void){/*{{{*/

	return DoubleInput2Enum;

}
/*}}}*/

/*DoubleInput2 management*/
void DoubleInput2::GetInput(IssmDouble* pvalue,int index){/*{{{*/

	if(index<0){
		printf("-------------- file: DoubleInput2.cpp line: %g\n",__LINE__); 
	}
	_assert_(index>=0); 
	_assert_(index<this->size); 

	*pvalue = this->values[index];
}
/*}}}*/
void DoubleInput2::SetInput(int index,IssmDouble value){/*{{{*/

	_assert_(index>=0); 
	_assert_(index<this->size); 

	this->values[index] = value;
}
/*}}}*/

/*Object functions*/
