function plot_transient_field(md,options,width,i,data)
%PLOT_TRANSIENT_FIELD - plot transient results
%
%   Usage:
%      plot_transient_field(md,options,width,i,data);
%
%   See also: PLOTMODEL

%Check that they are transient results
if ~isfield(md.results,'transient'),
	error('plot_transient_field error message: no transient results in the model');
end

fontsize  =getfieldvalue(options,'fontsize',14);
fontweight=getfieldvalue(options,'fontweight','n');
figurenum =getfieldvalue(options,'figure',1);

%Figure out the iterations to plot and check if it is possible
steps=getfieldvalueerr(options,'steps');
maxiteration=size(md.results.transient,2);
if max(steps)>maxiteration | min(steps)<1,
	error(['plot_transient_field error message: problem with the steps requested, must be an interger between 0 and ' num2str(maxiteration)]);
end

%Figure out the field to plot
if strncmpi(fliplr(data),fliplr('vx'),2),
	field='vx';
elseif strncmpi(fliplr(data),fliplr('vy'),2),
	field='vy';
elseif strncmpi(fliplr(data),fliplr('vz'),2),
	field='vz';
elseif strncmpi(fliplr(data),fliplr('vel'),3),
	field='vel';
elseif strncmpi(fliplr(data),fliplr('pressure'),8),
	field='pressure';
elseif strncmpi(fliplr(data),fliplr('melting'),6),
	field='melting';
elseif strncmpi(fliplr(data),fliplr('temperature'),11),
	field='temperature';
elseif strncmpi(fliplr(data),fliplr('bed'),3),
	field='bed';
elseif strncmpi(fliplr(data),fliplr('thickness'),9),
	field='thickness';
elseif strncmpi(fliplr(data),fliplr('surface'),7),
	field='surface';
end

string='plotmodel(md';
for i=1:length(steps),
	string=[string ',''data'',md.results.transient(' num2str(steps(i)) ').' field  ',''title'',''' field ' at time ' num2str(md.results.transient(steps(i)).time) ' a'''];
end
string=[string ',''colorbar#all'',''on'',''fontsize'',' num2str(fontsize) ',''fontweight'',''' fontweight ''',''figure'',' num2str(figurenum)];

%Add options
if exist(options,'caxis'),
	caxis_opt=getfieldvalue(options,'caxis',[]);
	string=[string ',''caxis'',[' num2str(caxis_opt(1)) ',' num2str(caxis_opt(2)) ']'];
end

%Execute string
string=[string ');'];
eval(string);
clear string;
