from MatlabFuncs import *
from copy import deepcopy
from helpers import *
from normal_uncertain import *
from uniform_uncertain import *


def QmuSetupVariables(md, variables):
    #get descriptor
    descriptor = variables.descriptor

    #decide whether this is a distributed variable, which will drive whether we expand it into npart values,
    #or if we just carry it forward as is.

    dvar = []

    #ok, key off according to type of descriptor:
    if strncmp(descriptor, 'scaled_', 7):
        #we have a scaled variable, expand it over the partition.
        if isinstance(variables, uniform_uncertain):
            if ((type(variables.lower) in [list, np.ndarray] and len(variables.lower) > md.qmu.numberofpartitions) or (type(variables.upper) in [list, np.ndarray] and len(variables.upper) > md.qmu.numberofpartitions)):
                raise RuntimeError('QmuSetupDesign error message: upper and lower should be either a scalar or a "npart" length vector')
        elif isinstance(variables, normal_uncertain):
            if type(variables.stddev) in [list, np.ndarray] and len(variables.stddev) > md.qmu.numberofpartitions:
                raise RuntimeError('QmuSetupDesign error message: stddev should be either a scalar or a "npart" length vector')

        #ok, dealing with semi-discrete distributed variable. Distribute according to how many
        #partitions we want
        for j in range(md.qmu.numberofpartitions):
            dvar.append(deepcopy(variables))

            # text parsing in dakota requires literal "'identifier'" not just "identifier"
            dvar[-1].descriptor = "'" + str(variables.descriptor) + '_' + str(j + 1) + "'"

            if isinstance(variables, uniform_uncertain):
                if type(variables.lower) in [list, np.ndarray]:
                    dvar[-1].lower = variables.lower[j]
                else:
                    dvar[-1].lower = variables.lower
                if type(variables.upper) in [list, np.ndarray]:
                    dvar[-1].upper = variables.upper[j]
                else:
                    dvar[-1].upper = variables.upper
            elif isinstance(variables, normal_uncertain):
                if type(variables.stddev) in [list, np.ndarray]:
                    dvar[-1].stddev = variables.stddev[j]
                else:
                    dvar[-1].stddev = variables.stddev
                if type(variables.mean) in [list, np.ndarray]:
                    dvar[-1].mean = variables.mean[j]
                else:
                    dvar[-1].mean = variables.mean
    else:
        dvar.append(deepcopy(variables))

        # text parsing in dakota requires literal "'identifier'" not just "identifier"
        dvar[-1].descriptor = "'" + str(variables.descriptor) + "'"

    return dvar
