function maxtime=timesteps(md,vx,vy);
%TIMESTEPS - return the maximum timesteps for the model in years
%
%   Dt < c Dx/u
%
%   Usage:
%      maxtime=timesteps(md,vx,vy);
%
%   Example:
%      dt=timesteps(md,md.results.diagnostic.vx,md.results.diagnostic.vy);

%Check length of velocities 
if size(vx,1)~=md.numberofgrids & size(vy,1)~=md.numberofgrids,
	error('timestpes error message: size of velocity components must be the same as md.numberofgrids');
end

index=md.elements;
edgex=max(md.x(index),[],2)-min(md.x(index),[],2);
edgey=max(md.y(index),[],2)-min(md.y(index),[],2);
vx=max(abs(vx(index)),[],2);
vy=max(abs(vy(index)),[],2);

maxtime=min(1/2*(edgex./vx+edgey./vy));
