#!/bin/bash
set -eu


# Constants
#
GSL_ROOT=${ISSM_DIR}/externalpackages/gsl
VER="1.15"

# Cleanup=
rm -rf install src
mkdir install src

# Download source
${ISSM_DIR}/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/gsl-${VER}.tar.gz" "gsl-${VER}.tar.gz"

# Unpack source
tar -zxvf gsl-${VER}.tar.gz

# Move source to 'src' directory
mv gsl-${VER}/* src
rm -rf gsl-${VER}

# Configure
cd src
./configure \
	--prefix="${GSL_ROOT}/install" \
	--disable-shared \
	--with-pic

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi
