%NORMAL_UNCERTAIN class definition
%
%   Usage:
%      nuv=normal_uncertain('descriptor',descriptor,'mean',mean,'stddev',stddev,'partition',partition);
%      where nuv is the normal_uncertain object returned by the constructor, mean and stddev are self 
%      explanatory.  partition is the partition vector for distributed variables. Can be a partition 
%      vector over elements or vertices.
% 
%   Example:
%      md.qmu.variables.rheology=normal_uncertain('descriptor','RheologyBBar','mean',1,'stddev',.05);
%      md.qmu.variables.rheology=normal_uncertain('descriptor','scaled_RheologyBBar','mean',1,'stddev',.05,'partition',vpartition);
% 

classdef normal_uncertain
    properties
        descriptor='';
        mean      = NaN;
        stddev    = NaN;
		partition = [];
    end
    methods
        function self=normal_uncertain(varargin) %constructor {{{

			%recover options: 
			options = pairoptions(varargin{:});

			%initialize fields: 
			self.descriptor=getfieldvalue(options,'descriptor');
			self.mean=getfieldvalue(options,'mean');
			self.stddev=getfieldvalue(options,'stddev');

        end %}}}
        function []=disp(nuv) % {{{

%  display the object

            disp(sprintf('\n'));
            for i=1:numel(nuv)
                disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
                    class(nuv),inputname(1),string_dim(nuv,i)));
                disp(sprintf('    descriptor: ''%s'''  ,nuv(i).descriptor));
                disp(sprintf('          mean: %g'      ,nuv(i).mean));
                disp(sprintf('        stddev: %g'      ,nuv(i).stddev));
            end

        end 
		%}}}
        function [desc]  =prop_desc(nuv,dstr) % {{{
            desc=cell(1,numel(nuv));
            for i=1:numel(nuv)
                if ~isempty(nuv(i).descriptor)
                    desc(i)=cellstr(nuv(i).descriptor);
                elseif ~isempty(inputname(1))
                    desc(i)=cellstr([inputname(1) string_dim(nuv,i,'vector')]);
                elseif exist('dstr','var')
                    desc(i)=cellstr([dstr         string_dim(nuv,i,'vector')]);
                else
                    desc(i)=cellstr(['nuv'        string_dim(nuv,i,'vector')]);
                end
            end
            desc=allempty(desc);
        end %}}}
        function [mean]  =prop_mean(nuv) % {{{
            mean=zeros(1,numel(nuv));
            for i=1:numel(nuv)
                mean(i)=nuv(i).mean;
            end
        end % }}}
        function [stddev]=prop_stddev(nuv) % {{{
            stddev=zeros(1,numel(nuv));
            for i=1:numel(nuv)
                stddev(i)=nuv(i).stddev;
            end
        end % }}}

	%virtual functions needed by qmu processing algorithms:
		function [abscissas] =prop_abscissas(hbu) % {{{
            abscissas=[]; 
        end % }}}
        function [counts] =prop_counts(hbu) % {{{
            counts=[]; 
        end % }}}
        function [pairs_per_variable] =prop_pairs_per_variable(hbu) % {{{
			pairs_per_variable=[];
        end % }}}
        function [initpt]=prop_initpt(nuv) % {{{
            initpt=[];
        end % }}}
        function [lower]  =prop_lower(nuv) % {{{
			lower=[];
        end % }}}
        function [upper]  =prop_upper(nuv) % {{{
			upper=[];
        end % }}}
        function [initst]=prop_initst(nuv) % {{{
            initst=[];
        end % }}}
        function [stype] =prop_stype(nuv) % {{{
            stype={};
        end % }}}
        function [scale] =prop_scale(nuv) % {{{
            scale=[];
        end % }}}
    end
    methods (Static)
        function []=dakota_write(fidi,dvar) % {{{
			%  collect only the variables of the appropriate class
			nuv=struc_class(dvar,'normal_uncertain');
			%  write variables
            vlist_write(fidi,'normal_uncertain','nuv',nuv);
        end % }}}
    end
end
