function maxtime=timesteps(md,vx,vy);
%TIMESTEPS - return the maximum timesteps for the model in years
%
%   Dt < c Dx/u
%
%   Usage:
%      maxtime=timesteps(md,vx,vy);
%
%   Example:
%      dt=timesteps(md,md.results.diagnostic.vx,md.results.diagnostic.vy);

%Check length of velocities 
if size(vx,1)~=md.numberofgrids & size(vy,1)~=md.numberofgrids,
	error('timestpes error message: size of velocity components must be the same as md.numberofgrids');
end

edgex=max(md.x(md.elements),[],2)-min(md.x(md.elements),[],2);
edgey=max(md.y(md.elements),[],2)-min(md.y(md.elements),[],2);
vx=max(vx(md.elements),[],2);
vy=max(vy(md.elements),[],2);

maxtime=1/2*(edgex/vx+edgey/vy);
