function [data isongrid isquiver]=processdata(md,data,options);
%PROCESSDATA - process data to be plotted
%
%   Usage:
%      [data isongrid isquiver]=processdata(md,data,options);
%
%   See also: PLOTMODEL, PROCESSMESH

%check format
if (iscell(data) | isempty(data) | length(data)==1),
	error('plotmodel error message: data provided is empty');
end

%transpose data if necessary
if (size(data,2) > size(data,1)),
	data=data';
end
datasize=size(data);

%check length
if datasize(1)~=md.numberofgrids & datasize(1)~=md.numberofelements & datasize(1)~=md.numberofgrids*6 & (strcmpi(md.type,'3d') & ~(datasize(1)==md.numberofelements2d | datasize(1)==md.numberofgrids2d))
	error('plotmodel error message: data not supported yet');
end

%isquiver?
if datasize(2)>1,
	isquiver=1;

	%check number of columns, add zeros if necessary,
	if (strcmpi(md.type,'3d'))
		if datasize(2)==2,
			data=[data, zeros(datasize(1),1)];
		elseif datasize(2)~=3,
			error('plotmodel error message: data provided should have 2 or 3 columns for quiver plot, and 1 for regular plot');
		end
	elseif (strcmpi(md.type,'2d') & datasize(2)~=2),
		error('plotmodel error message: data provided should have 2 columns for quiver plot, and 1 for regular plot');
	end

else
	isquiver=0;
end

%treat the case datasize(1)=6*grids
if datasize(1)==6*md.numberofgrids
	%keep the only norm of data
	data1=data(1:6:md.numberofgrids*6,:);
	data2=data(2:6:md.numberofgrids*6,:);
	data=sqrt(data1.^2+data2.^2);
	datasize(1)=md.numberofgrids;
	%---> go to grid data
end

%treat the case datasize(1)=grids2d
if (strcmpi(md.type,'3d') & datasize(1)==md.numberofgrids2d),
	data=project3d(md,data,'node');
	datasize(1)=md.numberofgrids;
	%---> go to grid data
end

%treat the case datasize(1)=grids2d
if (strcmpi(md.type,'3d') & datasize(1)==md.numberofelements2d),
	data=project3d(md,data,'element');
	datasize(1)=md.numberofelements;
	%---> go to grid data
end

%smoothing?
if exist(options,'smooth')
	data=averaging(md,data,getfieldvalue(options,'smooth'));
	datasize(1)=md.numberofgrids;
	%---> go to grid data
end

%element data
if datasize(1)==md.numberofelements;
	isongrid=0;

	%ice sheet only?
	if getfieldvalue(options,'iceshelf',1)==0,
		data(find(md.elementoniceshelf),:)=NaN;
	end
	%ice shelf only?
	if getfieldvalue(options,'icesheet',1)==0,
		data(find(~md.elementoniceshelf),:)=NaN;
	end
	%no water?
	if getfieldvalue(options,'water',1)==0,
		data(find(md.elementonwater),:)=NaN;
	end
	%log?
	if exist(options,'log'),
		pos=find(~isnan(data));
		data(pos)=log(data(pos))/log(getfieldvalue(options,'log'));
	end
end

%grid data
if datasize(1)==md.numberofgrids
	isongrid=1;
	%ice sheet only?
	if getfieldvalue(options,'iceshelf',1)==0,
		pos=find(md.gridoniceshelf);
		data(pos,:)=NaN;
	end
	%ice shelf only?
	if getfieldvalue(options,'icesheet',1)==0,
		pos=find(md.gridonicesheet);
		data(pos,:)=NaN;
	end
	%no water?
	if getfieldvalue(options,'water',1)==0,
		pos=find(md.gridonwater);
		data(pos,:)=NaN;
	end
	%log?
	if exist(options,'log'),
		data=log(data)/log(getfieldvalue(options,'log'));
	end

end

%layer projection? 
if getfieldvalue(options,'layer',0)>=1,
	data=project2d(md,data,getfieldvalue(options,'layer')); %project onto 2d mesh
end

%control arrow density if quiverplot
if isquiver & exist(options,'density')
	databak=data;
	data=NaN*ones(datasize);
	density=getfieldvalue(options,'density');
	data(1:density:end,:)=databak(1:density:end,:);
	clear databak
end
