function string = epsg2proj(epsg)
%use gdalsrsinfo to provide Proj.4 compatible string from EPSG code
%
%   Usage:
%      proj4string = epsg2proj(4326);
%
%   Example: 
%      proj4string = epsg2proj(4326); 
%      return proj4string='+proj=longlat +datum=wgs84 +no_defs '
%

	[s,r]=system(['gdalsrsinfo  epsg:' num2str(epsg)  ' | grep PROJ.4']);

	if s~=0, 
		error(r);
	end
	string=r(11:end-2);
