#!/bin/bash


## Constants
#
LIBGFORTRAN="/usr/lib/x86_64-linux-gnu/libgfortran.so.5.0.0" # Important that this is the library itself
LIBGFORTRAN_DIST="${ISSM_DIR}/lib/libgfortran.so.5" # Important the file name matches the SONAME entry in the binaries and other shared libraries which link to it
MATLAB_NROPTIONS="'id',[IdFromString('Dakota')],'exclude',[234,243,420,435,444,445,701,702,703]" # Exclude any tests with transient solutions that require a restart
MATLAB_PATH="/usr/local/MATLAB/R2019b"
PACKAGE="ISSM" # Name of directory to copy distributable files to

# Exclude any tests with transient solutions that require a restart
#
# NOTE:
# - All non-excluded tests were running until recent changes to QMU
# - 418 fails with "malloc(): invalid next size (unsorted)""
#
PYTHON_NROPTIONS="--include_name 'Dakota' --exclude 234 243 418 420 435 444 445 701 702 703"
TARBALL_NAME="issm-linux-with_dakota"
TARBALL="${TARBALL_NAME}.tar.gz"

# Clean up from previous packaging
echo "Cleaning up existing assets"
cd ${ISSM_DIR}
rm -rf ${PACKAGE}
mkdir ${PACKAGE}

# Add/modify required binaries
cd ${ISSM_DIR}/bin

echo "Modifying generic"
cat generic_static.m | sed -e "s/generic_static/generic/g" > generic.m
cat generic_static.py | sed -e "s/generic_static/generic/g" > generic.py

echo "Moving MPICH binaries to bin/"
if [ -f ${ISSM_DIR}/externalpackages/petsc/install/bin/mpiexec ]; then
	cp ${ISSM_DIR}/externalpackages/petsc/install/bin/mpiexec .
	cp ${ISSM_DIR}/externalpackages/petsc/install/bin/hydra_pmi_proxy .
elif [ -f ${ISSM_DIR}/externalpackages/mpich/install/bin/mpiexec ]; then
	cp ${ISSM_DIR}/externalpackages/mpich/install/bin/mpiexec .
	cp ${ISSM_DIR}/externalpackages/mpich/install/bin/hydra_pmi_proxy .
else
	echo "MPICH not found"
	exit 1
fi

# Add/modify required libraries
echo "Moving libgfortran to lib/"
cp ${LIBGFORTRAN} ${LIBGFORTRAN_DIST} 2> /dev/null

# # Run tests
# echo "Running tests"
# cd ${ISSM_DIR}/test/NightlyRun

# # Check that MATLAB tests run
# echo "Running MATLAB tests"

# rm matlab.log 2> /dev/null

# # Run MATLAB tests redirecting output to logfile and suppressing output to console
# ${MATLAB_PATH}/bin/matlab -nojvm -nosplash -r "try, addpath ${ISSM_DIR}/bin ${ISSM_DIR}/lib; runme(${MATLAB_NROPTIONS}); exit; catch me,fprintf('%s',getReport(me)); exit; end" -logfile matlab.log &> /dev/null

# # Check that MATLAB did not exit in error
# matlabExitCode=`echo $?`
# matlabExitedInError=`grep -E "Activation cannot proceed|license" matlab.log | wc -l`

# if [[ ${matlabExitCode} -ne 0 || ${matlabExitedInError} -ne 0 ]]; then
# 	echo "----------MATLAB exited in error!----------"
# 	cat matlab.log
# 	echo "-----------End of matlab.log-----------"

# 	# Clean up execution directory
# 	rm -rf ${ISSM_DIR}/execution/*

# 	exit 1
# fi

# # Check that all MATLAB tests passed
# numMatlabTestsFailed=`cat matlab.log | grep -c -e "FAILED|ERROR"`

# if [[ ${numMatlabTestsFailed} -ne 0 ]]; then
# 	echo "One or more MATLAB tests FAILED"
# 	exit 1;
# else
# 	echo "All MATLAB tests PASSED"
# fi

# # Check that Python tests run
# echo "Running Python tests"

# export PATH="${PATH}:${ISSM_DIR}/bin"
# export PYTHONPATH="${ISSM_DIR}/src/m/dev"
# export PYTHONSTARTUP="${PYTHONPATH}/devpath.py"
# export PYTHONUNBUFFERED=1 # We don't want Python to buffer output, otherwise issm.exe output is not captured

# rm python.log 2> /dev/null
# ./runme.py ${PYTHON_NROPTIONS} &> python.log 2>&1

# # Check that Python did not exit in error
# pythonExitCode=`echo $?`
# pythonExitedInError=`grep -E "Error|Traceback|bad interpreter" python.log | wc -l`

# if [[ ${pythonExitCode} -ne 0 || ${pythonExitedInError} -ne 0 ]]; then
# 	echo "----------Python exited in error!----------"
# 	cat python.log
# 	echo "-----------End of python.log-----------"

# 	# Clean up execution directory
# 	rm -rf ${ISSM_DIR}/execution/*

# 	exit 1
# fi

# # Check that all Python tests passed
# numPythonTestsFailed=`cat python.log | grep -c -e "FAILED|ERROR"`

# if [[ ${numPythonTestsFailed} -ne 0 ]]; then
# 	echo "One or more Python tests FAILED"
# 	exit 1
# else
# 	echo "All Python tests PASSED"
# fi

# Create tarball
cd ${ISSM_DIR}
rm -f ${TARBALL}
svn cleanup --remove-ignored --remove-unversioned test # Clean up test directory (before copying to package)
echo "Copying assets to package: ${PACKAGE}"
cp -rf bin examples lib scripts test ${PACKAGE}/
echo "Cleaning up unneeded/unwanted files"
python -m compileall ${PACKAGE}/bin # Precompile all Python scripts to bytecode
rm -f ${PACKAGE}/bin/*.py # Remove all Python scripts
rm -f ${PACKAGE}/bin/generic_static.* # Remove static versions of generic cluster classes
rm -f ${PACKAGE}/lib/*.a # Remove static libraries from package
rm -f ${PACKAGE}/lib/*.la # Remove libtool libraries from package
echo "Creating tarball: ${TARBALL_NAME}"
tar -czf ${TARBALL} ${PACKAGE}
ls -lah ${ISSM_DIR}/${TARBALL}

echo "Transferring binaries to ISSM Web site"
scp -i ~/.ssh/debian_linux-vm_to_ross ${TARBALL} jenkins@ross.ics.uci.edu:/var/www/html/${TARBALL}

if [ $? -ne 0 ]; then
	echo "FAILED: Manually check connection"
	exit 1
else
	echo "SUCCESS"
fi
