function field = get(parameterinputs,field_name,varargin)
%ADD - get a parameter input with name "field_name". 
%
%   Usage:
%      parameterinputs = get(parameterinputs,field_name,varargin)
%      optional argument: list of dofs being kept.
%      ex: 
%              parameterinputs=get(parameterinputs,'velocity',[1 1 0]); %only keep vx,vy
%              parameterinputs=get(parameterinputs,'velocity',[1 1 1]); %keep vx,vy,vz

field=[]; %in case we find nothing

for i=1:length(parameterinputs),

	if strcmpi(field_name,getname(parameterinputs(i).input)),

		%found the field, call the get method
		field=get(parameterinputs(i).input,varargin{:});
		return;
	end
end
