function input = input(varargin)
%INPUTS - contructor for input objects
%
%   Usage:
%      input = input()
%      input = input(name,field,field_type)

STRING=0;
INTEGER=1;
DOUBLE=2;
DOUBLEVEC=3;

switch nargin
case 0
	input.name='';
	input.type=DOUBLE;

	%placeholders:
	input.string='';
	input.integer=NaN;
	input.double=NaN;
	input.vector=[];
	input.ndof=NaN;
	input.numberofnodes=NaN;
	
	input=class(input,'input');
	

case  3
	name=varargin{1};
	field=varargin{2};
	field_type=varargin{3};

	if ~ischar(name),
		error('in input(name,field,field_type) constructor call, name is a string');
	end

	if ~ischar(field_type),
		error('in input(name,field,field_type) constructor call, field_type is a string: ''string'',''integer'',''double'' or ''doublevec'' ');
	end

	input.name='';
	input.type=DOUBLE;

	%placeholders:
	input.string='';
	input.integer=NaN;
	input.double=NaN;
	input.vector=[];
	input.ndof=NaN;
	input.numberofnodes=NaN;

	%fill fields
	input.name=name;
	if strcmpi(field_type,'string'),
		input.type=STRING;
		input.string=field;
	end

	if strcmpi(field_type,'integer'),
		input.type=INTEGER;
		input.integer=field;
	end

	if strcmpi(field_type,'double'),
		input.type=DOUBLE;
		input.double=field;
	end

	if strcmpi(field_type,'doublevec'),
		input.type=DOUBLEVEC;
		input.vector=field;
		input.ndof=1;
		input.numberofnodes=length(input.vector);
	end
	input=class(input,'input');

case  5
	name=varargin{1};
	field=varargin{2};
	field_type=varargin{3};
	ndof=varargin{4};
	numberofnodes=varargin{5};

	if ~ischar(name),
		error('in input(name,field,field_type) constructor call, name is a string');
	end

	if ~ischar(field_type),
		error('in input(name,field,field_type) constructor call, field_type is a string: ''string'',''integer'',''double'' or ''doublevec'' ');
	end

	input.name='';
	input.type=DOUBLE;

	%placeholders:
	input.string='';
	input.integer=NaN;
	input.double=NaN;
	input.vector=[];
	input.ndof=NaN;
	input.numberofnodes=NaN;

	%fill fields
	input.name=name;
	if strcmpi(field_type,'string'),
		input.type=STRING;
		input.string=field;
	end

	if strcmpi(field_type,'integer'),
		input.type=INTEGER;
		input.integer=field;
	end

	if strcmpi(field_type,'double'),
		input.type=DOUBLE;
		input.double=field;
	end

	if strcmpi(field_type,'doublevec'),
		input.type=DOUBLEVEC;
		input.vector=field;
		input.ndof=ndof;
		input.numberofnodes=numberofnodes;
		if (input.ndof*input.numberofnodes)~=length(input.vector),
			error(['length of vector ''',input.name,''' should be ndof*numberofnodes=' num2str(ndof*numberofnodes)]);
		end
	end
	input=class(input,'input');


otherwise
	error('input constructor error message: 0 of 1 argument only in input.');
end
