function field=get(input,varargin)
%GET - returns field from input 
%      usage:  
%          field=get(input);
%          field=get(input,doflist); %dof flag list for doublevec vectors. 
%
%          ex: velocity=get(input)
%          or: velocity=get(input,[1 1 0]); %get only vx and vy
%          or: velocity=get(input,[1 1 1]); %get vx,vy and vz
%


STRING=0;
INTEGER=1;
DOUBLE=2;
DOUBLEVEC=3;

field=[]; %in case nothing is returned
if input.type==STRING,
	field=input.string;
end

if input.type==INTEGER,
	field=input.integer;
end

if input.type==DOUBLE,
	field=input.double;
end

if input.type==DOUBLEVEC,
	if nargin==1,
		field=input.double;
	else
		doflist=varargin{1};
		numdofs=numel(find(doflist));
		field=zeros(numdofs*input.numberofnodes,1);

		count=0;
		for i=1:length(doflist),
			if doflist(i),
				count=count+1;
				field(count:numdofs:end)=input.vector(i:input.ndof:end);
			end
		end
	end
end
