function display(input)
%DISPLAY - displays the fields of an input object
%
%   echo function for 'input' class

STRING=0;
INTEGER=1;
DOUBLE=2;
DOUBLEVEC=3;

if isempty(input.name),
	%do nothing
	return;
end

%disp(sprintf('\n%s = \n',inputname(1)));

switch input.type, 
	case STRING,
		disp(sprintf('   %s(string): %s',input.name,input.string));
	case INTEGER,
		disp(sprintf('   %s(integer): %i',input.name,input.integer));
	case DOUBLE,
		disp(sprintf('   %s(double): %i',input.name,input.double));
	case DOUBLEVEC,
		disp(sprintf('   %s(vector): ndof %i numberofnodes %i ',input.name,input.ndof,input.numberofnodes));
		for i=1:length(input.vector),
			disp(sprintf('                  %g',input.vector(i)));
		end
end

