/*!\file:  ParameterInputsInits.cpp
 * \brief inputs routine is in the io for initializing a ParameterInputs structure out of the matlab workspace.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif


#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../include/macros.h"
#include "./io.h"

#undef __FUNCT__ 
#define __FUNCT__ "ParameterInputsInit" 

#ifdef _SERIAL_
void ParameterInputs::Init( void* vinput_handle){
	
	int i;
	int nelems;
	mxArray* input=NULL;
	const char* field_name=NULL;
	ConstDataHandle input_handle=NULL;
	int type;

	char* string=NULL;
	char* name=NULL;
	double scalar;
	int    integer;
	int    ndof;
	int    numberofnodes;
	double* vector=NULL;

	input_handle=(ConstDataHandle)vinput_handle;
	
	/*number of inputs: */
	nelems=mxGetNumberOfElements(input_handle);

	/*Go through ParameterInputs matlab structure, and recover each input object. Use it for fill 
	 * the ParameterInputs* "C" class object: */

	for(i=0;i<nelems;i++){

		/*Get i'th matlab input: */
		input=mxGetField(input_handle,i,"input");

		/*This input has the following fields: name, type, string, integer, double,  and vector. Plus ndof and numberofnodes: */
		//first get type
		type=(int)*mxGetPr(mxGetField(input,0,"type"));

		/*Get name: */
		name=mxArrayToString(mxGetField(input,0,"name"));

		if (strcmp(name,"")==0)continue; //this input has no name! can't register it. keep going.

		//string
		switch(type){
			case 0:
				//we have a string, recover it.
				string=mxArrayToString(mxGetField(input,0,"string"));
				//add to inputs.
				this->Add(name,string);
				xfree((void**)&string);
				break;
			case 1:
				//integer
				integer=(int)*(mxGetPr(mxGetField(input,0,"integer")));
				this->Add(name,integer);
				break;
			case 2: 
				//double
				scalar=(double)*(mxGetPr(mxGetField(input,0,"double")));
				this->Add(name,scalar);
				break;
			case 3: 
				//double vector
				vector=mxGetPr(mxGetField(input,0,"vector"));
				ndof=(int)*(mxGetPr(mxGetField(input,0,"ndof")));
				numberofnodes=(int)*(mxGetPr(mxGetField(input,0,"numberofnodes")));
				this->Add(name,vector,ndof,numberofnodes);
				break;
			default:
				throw ErrorException(__FUNCT__,exprintf("%s%i"," unknow parameter input type ",type));
		}

	}


}
#else
void ParameterInputs::Init( void* vinput_handle){
} 
#endif //#ifdef _SERIAL-
