/*\file PenaltySystemMatrices.c
 *\brief: build penalty matrices
 */

#include "./PenaltySystemMatrices.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Mat      Kgg=NULL;
	Vec      pg=NULL;
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	int         kflag,pflag;
	ParameterInputs* inputs=NULL;
	int               analysis_type;
	
	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&PenaltySystemMatricesUsage);

	/*Input datasets: */
	FetchData((void**)&Kgg,NULL,NULL,KGGIN,"Matrix",NULL);
	FetchData((void**)&pg,NULL,NULL,PGIN,"Vector",NULL);
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADS,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);
	/*parameters: */
	FetchData((void**)&kflag,NULL,NULL,mxGetField(PARAMETERS,0,"kflag"),"Integer",NULL);
	FetchData((void**)&pflag,NULL,NULL,mxGetField(PARAMETERS,0,"pflag"),"Integer",NULL);
	FetchData((void**)&analysis_type,NULL,NULL,mxGetField(PARAMETERS,0,"analysis_type"),"Integer",NULL);

	/*Fetch inputs: */
	inputs=new ParameterInputs;
	inputs->Init(INPUTS);

	/*!Generate stiffnesses from penalties: */
	PenaltySystemMatricesx(Kgg, pg,elements,nodes,loads,materials,kflag,pflag,inputs,analysis_type); 

	/*write output datasets: */
	WriteData(KGG,Kgg,0,0,"Matrix",NULL); 
	WriteData(PG,pg,0,0,"Vector",NULL); 
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	delete inputs;
	MatFree(&Kgg);
	VecFree(&pg);

	/*end module: */
	MODULEEND();
}

void PenaltySystemMatricesUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [Kgg,pg] = %s(Kggin,pgin,eleemnts,nodes,loads,materials,params,inputs);\n",__FUNCT__);
	_printf_("\n");
}
