/*\file PenaltyConstraints.c
 *\brief: set up penalty constraints
 */

#include "./PenaltyConstraints.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	ParameterInputs* inputs=NULL;
	int               analysis_type;

	/*output: */
	int converged;
	int num_unstable_constraints;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&PenaltyConstraintsUsage);

	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADSIN,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);
	
	/*parameters: */
	FetchData((void**)&analysis_type,NULL,NULL,mxGetField(PARAMETERS,0,"analysis_type"),"Integer",NULL);

	/*Fetch inputs: */
	inputs=new ParameterInputs;
	inputs->Init(INPUTS);

	/*!Generate internal degree of freedom numbers: */
	PenaltyConstraintsx(&converged, &num_unstable_constraints, elements,nodes,loads,materials,inputs,analysis_type); 

	/*write output datasets: */
	WriteData(LOADS,loads,0,0,"DataSet",NULL); 
	WriteData(CONVERGED,(void*)&converged,0,0,"Integer",NULL); 
	WriteData(NUMUNSTABLECONSTRAINTS,(void*)&num_unstable_constraints,0,0,"Integer",NULL); 
	
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	delete inputs;

	/*end module: */
	MODULEEND();
}

void PenaltyConstraintsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [loads, constraints_converged, num_unstable_constraints] = %s(elements,nodes,loads,materials,params,inputs);\n",__FUNCT__);
	_printf_("\n");
}
