function parameterinputs = add(parameterinputs,field_name,field,field_type,varargin)
%ADD - add an input to parameter inputs
%
%   Usage:
%      parameterinputs = add(parameterinputs,field_name,field,field_type)

found=0;

if length(parameterinputs)==0,
	parameterinputs
	parameterinputs(end+1).input=input(field_name,field,field_type,varargin);
else
	for i=1:length(parameterinputs),

		if strcmpi(field_name,getname(parameterinputs(i).input)),
			%replace this field by new field
			parameterinputs(i).input=input(field_name,field,field_type,varargin{:});
			found=1;
			break;
		end
	end


	%did we find the input name?
	if found,
		%we are done
	else
		%add at the end
		parameterinputs(end+1).input=input(field_name,field,field_type,varargin{:});
	end
end
if ~isa(parameterinputs,'parameterinputs'),
	parameterinputs=class(parameterinputs,'parameterinputs');
end
