/*!\file:  OptArgs.h
 * \brief place holder for optimization function arguments
 */ 

#ifndef OPTARGS_H_
#define OPTARGS_H_

#ifdef _SERIAL_

#include "mex.h"

struct OptArgs{

	char* function_name;
	mxArray* m;
	mxArray* p_g;
	mxArray* u_g_obs;
	mxArray* grad_g;
	mxArray* n;

};
#else

#include "./FemModel.h"
#include "./ParameterInputs.h"
class ParameterInputs;

struct OptArgs{
	FemModel* femmodel;
	double* p_g;
	double* u_g_obs;
	double* grad_g;
	ParameterInputs* inputs;
	int n;
};
#endif

#endif
